/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.javaxfaces;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.faces.application.ProjectStage;
import lombok.Generated;
import org.joinfaces.autoconfigure.javaxfaces.JavaxFaces2_0Properties;
import org.joinfaces.autoconfigure.javaxfaces.JavaxFacesAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ProjectStage.class})
@AutoConfigureBefore(value={JavaxFacesAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ProjectStageAutoConfiguration {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectStageAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"debug"})
    public static ProjectStageCustomizer developmentProjectStageCustomizer() {
        return new ProjectStageCustomizer(ProjectStage.Development);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"debug"}, havingValue="false", matchIfMissing=true)
    public static ProjectStageCustomizer productionProjectStageCustomizer() {
        return new ProjectStageCustomizer(ProjectStage.Production);
    }

    public static class ProjectStageCustomizer
    implements BeanPostProcessor {
        private final ProjectStage projectStage;

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof JavaxFaces2_0Properties && ((JavaxFaces2_0Properties)bean).getProjectStage() == null) {
                ((JavaxFaces2_0Properties)bean).setProjectStage(this.projectStage);
            }
            return bean;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProjectStageCustomizer(ProjectStage projectStage) {
            this.projectStage = projectStage;
        }
    }
}

