/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.jetty;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import lombok.Generated;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.joinfaces.autoconfigure.jetty.JettyProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={JettyProperties.class})
@ConditionalOnClass(value={Server.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class JettyAutoConfiguration {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JettyAutoConfiguration.class);
    private final JettyProperties jettyProperties;

    @Bean
    public WebServerFactoryCustomizer<JettyServletWebServerFactory> jsfJettyFactoryCustomizer() {
        return factory -> factory.addServerCustomizers(new JettyServerCustomizer[]{new JettyServerCustomizer(){

            public void customize(Server server) {
                Handler[] childHandlersByClass = server.getChildHandlersByClass(WebAppContext.class);
                WebAppContext webAppContext = (WebAppContext)childHandlersByClass[0];
                String classPathResourceString = JettyAutoConfiguration.this.jettyProperties.getClassPathResource();
                webAppContext.setBaseResource((Resource)new ResourceCollection(new Resource[]{Resource.newResource((URI)new ClassPathResource(classPathResourceString).getURI()), webAppContext.getBaseResource()}));
                log.info("Setting Jetty classLoader to {} directory", (Object)classPathResourceString);
            }
        }});
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JettyAutoConfiguration(JettyProperties jettyProperties) {
        this.jettyProperties = jettyProperties;
    }
}

