/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.omnifaces;

import org.joinfaces.autoconfigure.javaxfaces.JavaxFacesAutoConfiguration;
import org.joinfaces.autoconfigure.omnifaces.OmnifacesProperties;
import org.joinfaces.autoconfigure.servlet.initializer.ServletContainerInitializerRegistrationBean;
import org.omnifaces.facesviews.FacesViews;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={FacesViews.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={OmnifacesProperties.class})
@AutoConfigureBefore(value={JavaxFacesAutoConfiguration.class})
@ServletComponentScan(value={"org.omnifaces"})
public class OmnifacesAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.omnifaces.ApplicationInitializer"})
    public static class Omnifaces2AutoConfiguration {
        @Bean
        public ServletContainerInitializerRegistrationBean<?> omnifacesServletContainerInitializer() throws ClassNotFoundException {
            Class<?> applicationInitializerClass = Class.forName("org.omnifaces.ApplicationInitializer");
            return new ServletContainerInitializerRegistrationBean(applicationInitializerClass);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.omnifaces.facesviews.FacesViewsInitializer"})
    public static class Omnifaces1AutoConfiguration {
        @Bean
        public ServletContainerInitializerRegistrationBean<?> omnifacesServletContainerInitializer() throws ClassNotFoundException {
            Class<?> facesViewsInitializerClass = Class.forName("org.omnifaces.facesviews.FacesViewsInitializer");
            return new ServletContainerInitializerRegistrationBean(facesViewsInitializerClass);
        }
    }
}

