/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.session;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class SpringSessionFixFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        RequestWrapper wrappedRequest = new RequestWrapper(request);
        filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)response);
        HttpSession session = request.getSession(false);
        if (session != null && wrappedRequest.sessionWrapper != null) {
            this.reSetAttributes(wrappedRequest.sessionWrapper);
        }
    }

    private void reSetAttributes(SessionWrapper sessionWrapper) {
        HttpSession realSession = sessionWrapper.delegate;
        Enumeration attributeNames = realSession.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object attributeValue;
            String attributeName = (String)attributeNames.nextElement();
            if (!sessionWrapper.readAttributeNames.contains(attributeName) || ClassUtils.isPrimitiveOrWrapper((attributeValue = realSession.getAttribute(attributeName)).getClass())) continue;
            realSession.setAttribute(attributeName, attributeValue);
        }
    }

    static class SessionWrapper
    implements HttpSession {
        private final HttpSession delegate;
        @NonNull
        private final Set<String> readAttributeNames = new HashSet<String>();

        public long getCreationTime() {
            return this.delegate.getCreationTime();
        }

        public String getId() {
            return this.delegate.getId();
        }

        public long getLastAccessedTime() {
            return this.delegate.getLastAccessedTime();
        }

        public ServletContext getServletContext() {
            return this.delegate.getServletContext();
        }

        public void setMaxInactiveInterval(int interval) {
            this.delegate.setMaxInactiveInterval(interval);
        }

        public int getMaxInactiveInterval() {
            return this.delegate.getMaxInactiveInterval();
        }

        @Deprecated
        public HttpSessionContext getSessionContext() {
            return this.delegate.getSessionContext();
        }

        @Nullable
        public Object getAttribute(String name) {
            this.readAttributeNames.add(name);
            return this.delegate.getAttribute(name);
        }

        @Deprecated
        @Nullable
        public Object getValue(String name) {
            this.readAttributeNames.add(name);
            return this.delegate.getValue(name);
        }

        public Enumeration<String> getAttributeNames() {
            return this.delegate.getAttributeNames();
        }

        @Deprecated
        public String[] getValueNames() {
            return this.delegate.getValueNames();
        }

        public void setAttribute(String name, Object value) {
            this.delegate.setAttribute(name, value);
        }

        @Deprecated
        public void putValue(String name, Object value) {
            this.delegate.putValue(name, value);
        }

        public void removeAttribute(String name) {
            this.delegate.removeAttribute(name);
        }

        @Deprecated
        public void removeValue(String name) {
            this.delegate.removeValue(name);
        }

        public void invalidate() {
            this.delegate.invalidate();
        }

        public boolean isNew() {
            return this.delegate.isNew();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SessionWrapper(HttpSession delegate) {
            this.delegate = delegate;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Set<String> getReadAttributeNames() {
            return this.readAttributeNames;
        }
    }

    static class RequestWrapper
    extends HttpServletRequestWrapper {
        @Nullable
        private SessionWrapper sessionWrapper;

        RequestWrapper(HttpServletRequest request) {
            super(request);
        }

        @Nullable
        public HttpSession getSession(boolean create) {
            HttpSession session;
            if (this.sessionWrapper == null && (session = super.getSession(create)) != null) {
                this.sessionWrapper = new SessionWrapper(session);
            }
            return this.sessionWrapper;
        }

        public HttpSession getSession() {
            if (this.sessionWrapper == null) {
                this.sessionWrapper = new SessionWrapper(super.getSession());
            }
            return this.sessionWrapper;
        }
    }
}

