/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.javaxfaces;

import javax.faces.webapp.FacesServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.joinfaces.autoconfigure.javaxfaces.FacesServletProperties;
import org.joinfaces.autoconfigure.javaxfaces.JavaxFacesAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={JavaxFacesAutoConfiguration.class})
@ConditionalOnClass(value={FacesServlet.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={FacesServletProperties.class})
public class FacesServletAutoConfiguration {
    @Bean
    public ServletRegistrationBean<FacesServlet> facesServletRegistrationBean(FacesServletProperties facesServletProperties) {
        ServletRegistrationBean<FacesServlet> facesServletServletRegistrationBean = new ServletRegistrationBean<FacesServlet>(new FacesServlet(), new String[0]){

            protected ServletRegistration.Dynamic addRegistration(String description, ServletContext servletContext) {
                ServletRegistration.Dynamic servletRegistration = super.addRegistration(description, servletContext);
                if (servletRegistration != null) {
                    servletContext.setAttribute("org.apache.myfaces.DYNAMICALLY_ADDED_FACES_SERVLET", (Object)true);
                    servletContext.setAttribute("com.sun.faces.facesInitializerMappingsAdded", (Object)true);
                }
                return servletRegistration;
            }
        };
        facesServletServletRegistrationBean.setName(facesServletProperties.getName());
        facesServletServletRegistrationBean.setUrlMappings(facesServletProperties.getUrlMappings());
        facesServletServletRegistrationBean.setLoadOnStartup(facesServletProperties.getLoadOnStartup());
        facesServletServletRegistrationBean.setEnabled(facesServletProperties.isEnabled());
        facesServletServletRegistrationBean.setAsyncSupported(facesServletProperties.isAsyncSupported());
        facesServletServletRegistrationBean.setOrder(facesServletProperties.getOrder());
        return facesServletServletRegistrationBean;
    }
}

