/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.classgraph.ScanResult;
import jakarta.annotation.ManagedBean;
import jakarta.faces.component.FacesComponent;
import jakarta.faces.component.behavior.FacesBehavior;
import jakarta.faces.convert.FacesConverter;
import jakarta.faces.event.NamedEvent;
import jakarta.faces.render.FacesBehaviorRenderer;
import jakarta.faces.render.FacesRenderer;
import jakarta.faces.validator.FacesValidator;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.joinfaces.ClasspathScanUtil;

public final class FacesAnnotationProviderUtil {
    static final Set<Class<? extends Annotation>> CLASSES = Set.of(ManagedBean.class, FacesComponent.class, FacesBehavior.class, FacesConverter.class, NamedEvent.class, FacesRenderer.class, FacesBehaviorRenderer.class, FacesValidator.class);

    public static Map<Class<? extends Annotation>, Set<Class<?>>> findAnnotatedClasses(ScanResult scanResult) {
        HashMap annotatedClasses = new HashMap();
        for (Class<? extends Annotation> annotationClass : CLASSES) {
            LinkedHashSet classes = new LinkedHashSet();
            classes.addAll(scanResult.getClassesWithAnnotation(annotationClass).loadClasses());
            classes.addAll(scanResult.getClassesWithMethodAnnotation(annotationClass).loadClasses());
            classes.addAll(scanResult.getClassesWithFieldAnnotation(annotationClass).loadClasses());
            annotatedClasses.put(annotationClass, classes);
        }
        return annotatedClasses;
    }

    public static Optional<Map<Class<? extends Annotation>, Set<Class<?>>>> findPreparedScanResult(Class<?> spiClass, ClassLoader classLoader) {
        String resourceName = "META-INF/joinfaces/" + spiClass.getName() + ".classes";
        return ClasspathScanUtil.readClassMap((String)resourceName, (ClassLoader)classLoader);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private FacesAnnotationProviderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

