/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.primefaces;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletRegistration;
import org.joinfaces.autoconfigure.faces.JakartaFaces3AutoConfiguration;
import org.primefaces.webapp.MultipartRequest;
import org.primefaces.webapp.filter.FileUploadFilter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={MultipartRequest.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@AutoConfigureAfter(value={JakartaFaces3AutoConfiguration.class})
public class PrimefacesFileUploadServletContextAutoConfiguration {
    private static final String FACES_SERVLET_NAME = "FacesServlet";

    @ConditionalOnExpression(value="'${joinfaces.primefaces.uploader}' != 'commons'")
    @Bean
    public ServletContextInitializer primefacesFileUploadServletContextInitializer(MultipartConfigElement multipartConfigElement) {
        return servletContext -> {
            ServletRegistration servletRegistration = servletContext.getServletRegistration(FACES_SERVLET_NAME);
            if (servletRegistration instanceof ServletRegistration.Dynamic) {
                ((ServletRegistration.Dynamic)servletRegistration).setMultipartConfig(multipartConfigElement);
            }
        };
    }

    @Bean
    @ConditionalOnProperty(value={"joinfaces.primefaces.uploader"}, havingValue="commons")
    public FileUploadFilter fileUploadFilter() {
        return new FileUploadFilter();
    }
}

