/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.session;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.joinfaces.session.SpringSessionFixFilter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.session.SessionAutoConfiguration;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.Nullable;
import org.springframework.session.SessionRepository;
import org.springframework.session.web.http.SessionRepositoryFilter;

@AutoConfiguration(after={SessionAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={SessionProperties.class})
@ConditionalOnClass(value={SessionRepository.class})
public class SpringSessionFixAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={SessionRepositoryFilter.class})
    public FilterRegistrationBean<SpringSessionFixFilter> springSessionFixFilterRegistrationBean(SessionProperties sessionProperties) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)new SpringSessionFixFilter(), new ServletRegistrationBean[0]);
        registrationBean.setOrder(sessionProperties.getServlet().getFilterOrder() + 1);
        registrationBean.setDispatcherTypes(this.getDispatcherTypes(sessionProperties));
        return registrationBean;
    }

    @Nullable
    private EnumSet<DispatcherType> getDispatcherTypes(SessionProperties sessionProperties) {
        SessionProperties.Servlet servletProperties = sessionProperties.getServlet();
        if (servletProperties.getFilterDispatcherTypes() == null) {
            return null;
        }
        return servletProperties.getFilterDispatcherTypes().stream().map(type -> DispatcherType.valueOf((String)type.name())).collect(Collectors.collectingAndThen(Collectors.toSet(), EnumSet::copyOf));
    }
}

