/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.weld;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.api.helpers.RegistrySingletonProvider;
import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import org.jboss.weld.logging.WeldLogger;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;

public class WeldRuntimeHintsRegistrar
implements RuntimeHintsRegistrar {
    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        this.scanHints(hints, classLoader);
        hints.reflection().registerType(RegistrySingletonProvider.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
        hints.proxies().registerJdkProxy(new Class[]{Event.class});
    }

    void scanHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        ClassGraph classGraph = new ClassGraph().enableClassInfo();
        if (classLoader != null) {
            classGraph = classGraph.overrideClassLoaders(new ClassLoader[]{classLoader});
        }
        try (ScanResult scanResult = classGraph.scan();){
            for (ClassInfo loggerImpl : scanResult.getClassesImplementing(WeldLogger.class)) {
                this.registerLogger(hints, loggerImpl);
            }
            for (ClassInfo loggerImpl : scanResult.getClassesImplementing(WeldEnvironmentLogger.class)) {
                this.registerLogger(hints, loggerImpl);
            }
            for (ClassInfo classInfo : scanResult.getClassesImplementing(Extension.class)) {
                hints.reflection().registerType(TypeReference.of((String)classInfo.getName()), new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS});
            }
        }
    }

    void registerLogger(RuntimeHints hints, ClassInfo loggerImpl) {
        String implName = loggerImpl.getName();
        if (implName.endsWith("_$logger")) {
            hints.reflection().registerType(TypeReference.of((String)implName), builder -> {
                String interfaceName = implName.replace("_$logger", "");
                builder.onReachableType(TypeReference.of((String)interfaceName)).withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
            });
        }
    }
}

