/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.rewrite;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.joinfaces.autoconfigure.rewrite.RewriteFilterProperties;
import org.joinfaces.autoconfigure.rewrite.RewriteProperties;
import org.joinfaces.rewrite.SpringBootAnnotationConfigProvider;
import org.joinfaces.servlet.WebFragmentRegistrationBean;
import org.ocpsoft.rewrite.servlet.RewriteFilter;
import org.ocpsoft.rewrite.servlet.impl.RewriteServletContextListener;
import org.ocpsoft.rewrite.servlet.impl.RewriteServletRequestListener;
import org.ocpsoft.rewrite.spring.SpringExpressionLanguageProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.ConditionalOnMissingFilterBean;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={RewriteProperties.class, RewriteFilterProperties.class})
@ConditionalOnClass(value={RewriteFilter.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class RewriteAutoConfiguration {
    @Bean
    public WebFragmentRegistrationBean rewriteWebFragmentRegistrationBean() {
        WebFragmentRegistrationBean bean = new WebFragmentRegistrationBean();
        bean.getListeners().add(RewriteServletRequestListener.class);
        bean.getListeners().add(RewriteServletContextListener.class);
        return bean;
    }

    @Bean
    @ConditionalOnMissingFilterBean
    public FilterRegistrationBean<RewriteFilter> rewriteFilterRegistrationBean(RewriteFilterProperties rewriteFilterProperties) {
        FilterRegistrationBean rewriteFilterRegistrationBean = new FilterRegistrationBean((Filter)new RewriteFilter(), new ServletRegistrationBean[0]);
        rewriteFilterRegistrationBean.setName("OCPsoft Rewrite Filter");
        rewriteFilterRegistrationBean.setEnabled(rewriteFilterProperties.isEnabled());
        rewriteFilterRegistrationBean.setOrder(rewriteFilterProperties.getOrder());
        rewriteFilterRegistrationBean.setUrlPatterns(rewriteFilterProperties.getUrlPatterns());
        rewriteFilterRegistrationBean.setDispatcherTypes(RewriteAutoConfiguration.getDispatcherTypes(rewriteFilterProperties));
        return rewriteFilterRegistrationBean;
    }

    private static EnumSet<DispatcherType> getDispatcherTypes(RewriteFilterProperties rewriteFilterProperties) {
        return rewriteFilterProperties.getDispatcherTypes().stream().map(type -> DispatcherType.valueOf((String)type.name())).collect(Collectors.toCollection(() -> EnumSet.noneOf(DispatcherType.class)));
    }

    @Bean
    public SpringExpressionLanguageProvider rewriteExpressionLanguageProvider() {
        return new SpringExpressionLanguageProvider();
    }

    @Bean
    @ConfigurationProperties(value="joinfaces.rewrite.annotation-config-provider")
    public SpringBootAnnotationConfigProvider rewriteAnnotationConfigProvider() {
        return new SpringBootAnnotationConfigProvider();
    }
}

