/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.scopemapping;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.joinfaces.autoconfigure.scopemapping.AnnotationToScopeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.ClassUtils;

public class CustomScopeAnnotationConfigurer
implements BeanFactoryPostProcessor,
Ordered {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomScopeAnnotationConfigurer.class);
    private int order = Integer.MAX_VALUE;
    private List<AnnotationToScopeMapping> annotationToScopeMappings;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory clbf) throws BeansException {
        for (String beanName : clbf.getBeanDefinitionNames()) {
            BeanDefinition definition = clbf.getBeanDefinition(beanName);
            this.registerJsfCdiToSpring(definition);
        }
    }

    private void registerJsfCdiToSpring(BeanDefinition definition) {
        if (definition instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition annDef = (AnnotatedBeanDefinition)definition;
            String scopeName = null;
            scopeName = annDef.getFactoryMethodMetadata() != null ? this.deduceScopeName(annDef.getFactoryMethodMetadata()) : this.deduceScopeName(annDef.getMetadata());
            if (scopeName != null) {
                definition.setScope(scopeName);
                log.debug("{} - Scope({})", (Object)definition.getBeanClassName(), (Object)scopeName.toUpperCase());
            }
        }
    }

    protected String deduceScopeName(MethodMetadata factoryMethodMetadata) {
        if (this.getAnnotationToScopeMappings() == null) {
            return null;
        }
        for (AnnotationToScopeMapping annotationToScopeMapping : this.getAnnotationToScopeMappings()) {
            if (!factoryMethodMetadata.isAnnotated(annotationToScopeMapping.getAnnotation().getName())) continue;
            return annotationToScopeMapping.getScope();
        }
        return null;
    }

    protected String deduceScopeName(AnnotationMetadata classMetadata) {
        if (classMetadata == null || this.getAnnotationToScopeMappings() == null) {
            return null;
        }
        for (AnnotationToScopeMapping annotationToScopeMapping : this.getAnnotationToScopeMappings()) {
            if (!classMetadata.hasAnnotation(annotationToScopeMapping.getAnnotation().getName())) continue;
            return annotationToScopeMapping.getScope();
        }
        return null;
    }

    public void addMapping(Class<? extends Annotation> annotation, String scopeName) {
        this.addMapping(new AnnotationToScopeMapping(annotation, scopeName));
    }

    public void addMapping(String annotationName, String scopeName) throws ClassNotFoundException {
        Class aClass = ClassUtils.forName((String)annotationName, null);
        this.addMapping(aClass, scopeName);
    }

    public void addMapping(AnnotationToScopeMapping annotationToScopeMapping) {
        if (this.annotationToScopeMappings == null) {
            this.annotationToScopeMappings = new LinkedList<AnnotationToScopeMapping>();
        }
        this.annotationToScopeMappings.add(annotationToScopeMapping);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<AnnotationToScopeMapping> getAnnotationToScopeMappings() {
        return this.annotationToScopeMappings;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAnnotationToScopeMappings(List<AnnotationToScopeMapping> annotationToScopeMappings) {
        this.annotationToScopeMappings = annotationToScopeMappings;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CustomScopeAnnotationConfigurer() {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getOrder() {
        return this.order;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

