/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.servlet.initparams;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.joinfaces.autoconfigure.servlet.initparams.ServletContextInitParameter;
import org.joinfaces.autoconfigure.servlet.initparams.ServletContextInitParameterProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.convert.DataSizeUnit;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

public class InitParameterServletContextConfigurer
implements ServletContextInitializer,
Ordered {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InitParameterServletContextConfigurer.class);
    private final List<ServletContextInitParameterProperties> initParameterProperties;
    private final Set<String> visitedInitParameters;
    private ServletContext servletContext;
    private int order;

    public InitParameterServletContextConfigurer(List<ServletContextInitParameterProperties> initParameterProperties) {
        this.initParameterProperties = new ArrayList<ServletContextInitParameterProperties>(initParameterProperties);
        this.visitedInitParameters = new HashSet<String>();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void onStartup(ServletContext servletContext) {
        this.servletContext = servletContext;
        for (ServletContextInitParameterProperties properties : this.initParameterProperties) {
            this.handlePropertiesObject(properties);
        }
    }

    private void handlePropertiesObject(Object properties) {
        Class type = AopUtils.getTargetClass((Object)properties);
        ReflectionUtils.doWithFields((Class)type, field -> this.handlePropertiesField(properties, field), field -> AnnotatedElementUtils.isAnnotated((AnnotatedElement)field, ServletContextInitParameter.class) || AnnotatedElementUtils.isAnnotated((AnnotatedElement)field, NestedConfigurationProperty.class));
    }

    private void handlePropertiesField(Object properties, Field field) {
        ServletContextInitParameter servletContextInitParameter;
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)field, NestedConfigurationProperty.class)) {
            ReflectionUtils.makeAccessible((Field)field);
            Object nestedProperties = ReflectionUtils.getField((Field)field, (Object)properties);
            if (nestedProperties != null) {
                this.handlePropertiesObject(nestedProperties);
            } else {
                log.debug("Not visiting nested property {} because its null", (Object)field);
            }
        }
        if ((servletContextInitParameter = (ServletContextInitParameter)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, ServletContextInitParameter.class)) != null) {
            String paramName = servletContextInitParameter.value();
            if (this.visitedInitParameters.contains(paramName)) {
                log.debug("Not setting '{}' because it was already processed", (Object)paramName);
                return;
            }
            ReflectionUtils.makeAccessible((Field)field);
            Object value = ReflectionUtils.getField((Field)field, (Object)properties);
            if (value == null) {
                log.debug("Not setting '{}' because the value is null", (Object)paramName);
            } else {
                String paramValue = this.convertToString(field, value, servletContextInitParameter);
                log.debug("{} = {}", (Object)paramName, (Object)paramValue);
                this.servletContext.setInitParameter(paramName, paramValue);
            }
            this.visitedInitParameters.add(paramName);
        }
    }

    private String convertToString(Field field, Object value, ServletContextInitParameter servletContextInitParameter) {
        if (Collection.class.isAssignableFrom(field.getType())) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                return "";
            }
            return collection.stream().map(InitParameterServletContextConfigurer::convertToString).collect(Collectors.joining(servletContextInitParameter.listSeparator()));
        }
        if (Duration.class.isAssignableFrom(field.getType())) {
            ChronoUnit chronoUnit = InitParameterServletContextConfigurer.resolveChronoUnit(field);
            return InitParameterServletContextConfigurer.convertToString((Duration)value, chronoUnit);
        }
        if (DataSize.class.isAssignableFrom(field.getType())) {
            DataUnit dataUnit = InitParameterServletContextConfigurer.resolveDataSizeUnit(field);
            return InitParameterServletContextConfigurer.convertToString((DataSize)value, dataUnit);
        }
        return InitParameterServletContextConfigurer.convertToString(value);
    }

    static String convertToString(Duration duration, ChronoUnit chronoUnit) {
        return switch (chronoUnit) {
            case ChronoUnit.NANOS -> String.valueOf(duration.toNanos());
            case ChronoUnit.MILLIS -> String.valueOf(duration.toMillis());
            case ChronoUnit.SECONDS -> String.valueOf(duration.getSeconds());
            case ChronoUnit.MINUTES -> String.valueOf(duration.toMinutes());
            case ChronoUnit.HOURS -> String.valueOf(duration.toHours());
            default -> throw new IllegalStateException("Unsupported ChronoUnit: " + String.valueOf(chronoUnit));
        };
    }

    static String convertToString(DataSize dataSize, DataUnit dataUnit) {
        return switch (dataUnit) {
            case DataUnit.BYTES -> String.valueOf(dataSize.toBytes());
            case DataUnit.KILOBYTES -> String.valueOf(dataSize.toKilobytes());
            case DataUnit.MEGABYTES -> String.valueOf(dataSize.toMegabytes());
            case DataUnit.GIGABYTES -> String.valueOf(dataSize.toGigabytes());
            case DataUnit.TERABYTES -> String.valueOf(dataSize.toTerabytes());
            default -> throw new IllegalStateException("Unsupported DataUnit: " + String.valueOf(dataUnit));
        };
    }

    static String convertToString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        return value.toString();
    }

    static ChronoUnit resolveChronoUnit(Field field) {
        DurationUnit annotation = (DurationUnit)AnnotationUtils.findAnnotation((AnnotatedElement)field, DurationUnit.class);
        if (annotation != null) {
            return annotation.value();
        }
        return ChronoUnit.MILLIS;
    }

    static DataUnit resolveDataSizeUnit(Field field) {
        DataSizeUnit annotation = (DataSizeUnit)AnnotationUtils.findAnnotation((AnnotatedElement)field, DataSizeUnit.class);
        if (annotation != null) {
            return annotation.value();
        }
        return DataUnit.BYTES;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getOrder() {
        return this.order;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

