/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.gradle;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import javax.annotation.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.joinfaces.gradle.BomPlugin;
import org.joinfaces.gradle.ClasspathScanPlugin;

public class JoinfacesPlugin
implements Plugin<Project> {
    private static final String JOINFACES_VERSION = JoinfacesPlugin.determineJoinfacesVersion();
    public static final String BOM_COORDINATES = "org.joinfaces:joinfaces-dependencies:" + JOINFACES_VERSION;

    public void apply(Project project) {
        project.getPlugins().apply(ClasspathScanPlugin.class);
        project.getPlugins().withId("io.spring.dependency-management", plugin -> project.getPlugins().apply(BomPlugin.class));
    }

    @Nullable
    private static String determineJoinfacesVersion() {
        String string;
        String implementationVersion = BomPlugin.class.getPackage().getImplementationVersion();
        if (implementationVersion != null) {
            return implementationVersion;
        }
        URL codeSourceLocation = BomPlugin.class.getProtectionDomain().getCodeSource().getLocation();
        URLConnection connection = codeSourceLocation.openConnection();
        if (connection instanceof JarURLConnection) {
            return JoinfacesPlugin.getImplementationVersion(((JarURLConnection)connection).getJarFile());
        }
        JarFile jarFile = new JarFile(new File(codeSourceLocation.toURI()));
        try {
            string = JoinfacesPlugin.getImplementationVersion(jarFile);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | URISyntaxException ex) {
                return null;
            }
        }
        jarFile.close();
        return string;
    }

    private static String getImplementationVersion(JarFile jarFile) throws IOException {
        return jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }
}

