/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.maven;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.joinfaces.tools.ClasspathScanner;

@Mojo(name="classpath-scan", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class ClasspathScanMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(property="joinfaces.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.skipMojo();
        } else {
            this.executeMojo();
        }
    }

    private void skipMojo() {
        this.getLog().info((CharSequence)"Skipping JoinFaces execution because property joinfaces.skip is set.");
    }

    private void executeMojo() throws MojoExecutionException, MojoFailureException {
        HashSet classpath = new HashSet();
        try {
            classpath.addAll(this.project.getRuntimeClasspathElements());
            classpath.addAll(this.project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("classpath not present", (Exception)((Object)e));
        }
        try {
            ClasspathScanner.builder().classpathRoot(this.outputDirectory).classGraphConfigurer(classGraph -> classGraph.overrideClasspath((Iterable)classpath)).build().scanClasses();
        }
        catch (IOException e) {
            throw new MojoFailureException("Classpath scan failed", (Throwable)e);
        }
    }
}

