/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.tools;

import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Map;

public abstract class ScanResultHandler {
    public abstract void handle(ScanResult var1, File var2) throws IOException;

    protected void writeClassList(File file, Collection<String> classNames) throws IOException {
        File baseDir = file.getParentFile();
        if (!baseDir.isDirectory() && !baseDir.mkdirs()) {
            throw new IOException(baseDir + " does not exist and could not be created");
        }
        Files.write(file.toPath(), classNames, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    protected void writeClassMap(File file, Map<String, ? extends Collection<String>> classMap) throws IOException {
        File baseDir = file.getParentFile();
        if (baseDir.isDirectory() || baseDir.mkdirs()) {
            try (PrintWriter printWriter = new PrintWriter(file, "UTF-8");){
                classMap.forEach((key, value) -> {
                    printWriter.print((String)key);
                    printWriter.print("=");
                    printWriter.println(String.join((CharSequence)",", value));
                });
            }
        } else {
            throw new IOException(baseDir + " does not exist and could not be created");
        }
    }
}

