/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.tools;

import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.joinfaces.tools.ScanResultHandler;

public abstract class FacesAnnotationProviderHandler
extends ScanResultHandler {
    private final String spiClassName;
    private static final List<String> annotations = List.of("jakarta.faces.bean.ManagedBean", "jakarta.faces.component.FacesComponent", "jakarta.faces.component.behavior.FacesBehavior", "jakarta.faces.convert.FacesConverter", "jakarta.faces.event.NamedEvent", "jakarta.faces.render.FacesRenderer", "jakarta.faces.render.FacesBehaviorRenderer", "jakarta.faces.validator.FacesValidator");

    protected FacesAnnotationProviderHandler(String spiClassName) {
        this.spiClassName = spiClassName;
    }

    @Override
    public void handle(ScanResult scanResult, File classpathRoot) throws IOException {
        if (scanResult.getClassInfo(this.spiClassName) == null) {
            return;
        }
        LinkedHashMap result = new LinkedHashMap();
        for (String annotation : annotations) {
            LinkedHashSet annotatedClasses = new LinkedHashSet();
            annotatedClasses.addAll(scanResult.getClassesWithAnnotation(annotation).getNames());
            annotatedClasses.addAll(scanResult.getClassesWithMethodAnnotation(annotation).getNames());
            annotatedClasses.addAll(scanResult.getClassesWithFieldAnnotation(annotation).getNames());
            result.put(annotation, annotatedClasses);
        }
        File resultFile = new File(classpathRoot, "META-INF/joinfaces/" + this.spiClassName + ".classes");
        this.writeClassMap(resultFile, result);
    }
}

