/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.tools;

import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ClassRefTypeSignature;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodTypeSignature;
import io.github.classgraph.ScanResult;
import io.github.classgraph.TypeArgument;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.joinfaces.tools.ScanResultHandler;

public class RewriteAnnotationProviderHandler
extends ScanResultHandler {
    static final String REWRITE_ANNOTATION_HANDLER = "org.ocpsoft.rewrite.annotation.spi.AnnotationHandler";

    @Override
    public void handle(ScanResult scanResult, File classpathRoot) throws IOException {
        ClassInfoList annotationHandlers = scanResult.getClassesImplementing(REWRITE_ANNOTATION_HANDLER);
        if (annotationHandlers.isEmpty()) {
            return;
        }
        List annotationClassNames = annotationHandlers.stream().map(classInfo -> classInfo.getDeclaredMethodInfo("handles")).flatMap(Collection::stream).map(MethodInfo::getTypeSignature).map(MethodTypeSignature::getResultType).filter(ClassRefTypeSignature.class::isInstance).map(ClassRefTypeSignature.class::cast).map(classRefTypeSignature -> (TypeArgument)classRefTypeSignature.getTypeArguments().get(0)).map(TypeArgument::getTypeSignature).filter(ClassRefTypeSignature.class::isInstance).map(ClassRefTypeSignature.class::cast).map(ClassRefTypeSignature::getFullyQualifiedClassName).collect(Collectors.toList());
        File resultFile = new File(classpathRoot, "META-INF/joinfaces/org.ocpsoft.rewrite.annotation.spi.AnnotationHandler.classes");
        TreeSet<String> result = new TreeSet<String>(String::compareTo);
        for (String annotationClassName : annotationClassNames) {
            result.addAll(scanResult.getClassesWithAnnotation(annotationClassName).getNames());
            result.addAll(scanResult.getClassesWithFieldAnnotation(annotationClassName).getNames());
            result.addAll(scanResult.getClassesWithMethodAnnotation(annotationClassName).getNames());
        }
        this.writeClassList(resultFile, result);
    }
}

