/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.tools;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.classgraph.AnnotationClassRef;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.joinfaces.tools.ScanResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContainerInitializerHandler
extends ScanResultHandler {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServletContainerInitializerHandler.class);
    private static final String SERVLET_CONTAINER_INITIALIZER = "jakarta.servlet.ServletContainerInitializer";
    private static final String HANDLES_TYPES = "jakarta.servlet.annotation.HandlesTypes";

    @Override
    public void handle(ScanResult scanResult, File classpathRoot) throws IOException {
        ClassInfoList scis = scanResult.getClassesImplementing(SERVLET_CONTAINER_INITIALIZER).filter(classInfo -> classInfo.hasAnnotation(HANDLES_TYPES));
        for (ClassInfo sciClassInfo : scis) {
            List<ClassInfo> handledTypes = this.resolveHandledTypes(sciClassInfo);
            SortedSet<String> classes = this.findHandledClasses(scanResult, handledTypes);
            File resultFile = new File(classpathRoot, "META-INF/joinfaces/" + sciClassInfo.getName() + ".classes");
            this.writeClassList(resultFile, classes);
        }
    }

    private List<ClassInfo> resolveHandledTypes(ClassInfo servletContainerInitializerClassInfo) {
        AnnotationInfo handlesTypes = servletContainerInitializerClassInfo.getAnnotationInfo(HANDLES_TYPES);
        Object[] value = (Object[])((AnnotationParameterValue)handlesTypes.getParameterValues().get("value")).getValue();
        return Arrays.stream(value).map(AnnotationClassRef.class::cast).map(annotationClassRef -> {
            ClassInfo classInfo = annotationClassRef.getClassInfo();
            if (classInfo == null) {
                log.warn("{} not found in the scan result, but declared in the @HandlesTypes annotation of {}", (Object)annotationClassRef.getName(), (Object)servletContainerInitializerClassInfo.getName());
            }
            return classInfo;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private SortedSet<String> findHandledClasses(ScanResult scanResult, List<ClassInfo> handledTypes) {
        TreeSet<String> classes = new TreeSet<String>(String::compareTo);
        handledTypes.forEach(handledType -> {
            String name = handledType.getName();
            if (handledType.isAnnotation()) {
                classes.addAll(scanResult.getClassesWithAnnotation(name).getNames());
                classes.addAll(scanResult.getClassesWithMethodAnnotation(name).getNames());
                classes.addAll(scanResult.getClassesWithFieldAnnotation(name).getNames());
            } else if (handledType.isInterface()) {
                classes.addAll(scanResult.getClassesImplementing(name).getNames());
            } else {
                classes.addAll(scanResult.getSubclasses(name).getNames());
            }
        });
        return classes;
    }
}

