/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.integration;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.event.ViewMapListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.util.Assert;
import org.springframework.web.context.request.FacesRequestAttributes;

public class ViewScope
implements Scope {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViewScope.class);
    public static final String SCOPE_VIEW = "view";
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = ViewScope.class.getName() + ".DESTRUCTION_CALLBACK.";
    private PreDestroyViewMapListener preDestroyViewMapListener = new PreDestroyViewMapListener();

    public Object get(String name, ObjectFactory objectFactory) {
        Map viewMap = this.getViewRoot().getViewMap();
        Object bean = viewMap.get(name);
        if (bean == null) {
            bean = objectFactory.getObject();
            viewMap.put(name, bean);
        }
        return bean;
    }

    public Object remove(String name) {
        UIViewRoot viewRoot = this.getViewRoot();
        Object bean = viewRoot.getViewMap().remove(name);
        DestructionCallbackWrapper destructionCallbackWrapper = (DestructionCallbackWrapper)viewRoot.getViewMap().remove(DESTRUCTION_CALLBACK_NAME_PREFIX + name);
        if (destructionCallbackWrapper != null) {
            this.getSessionListener().unregister(destructionCallbackWrapper);
        }
        return bean;
    }

    public String getConversationId() {
        this.getFacesContext();
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        DestructionCallbackWrapper wrapper = new DestructionCallbackWrapper(name, callback);
        this.getFacesContext().getApplication().subscribeToEvent(PreDestroyViewMapEvent.class, (SystemEventListener)this.preDestroyViewMapListener);
        this.getViewRoot().getViewMap().put(DESTRUCTION_CALLBACK_NAME_PREFIX + name, wrapper);
        this.getSessionListener().register(wrapper);
    }

    public Object resolveContextualObject(String key) {
        return new FacesRequestAttributes(this.getFacesContext()).resolveReference(key);
    }

    private UIViewRoot getViewRoot() {
        UIViewRoot viewRoot = this.getFacesContext().getViewRoot();
        if (viewRoot == null) {
            throw new IllegalStateException("No ViewRoot found");
        }
        return viewRoot;
    }

    private FacesContext getFacesContext() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new IllegalStateException("No FacesContext found.");
        }
        return facesContext;
    }

    private SessionListener getSessionListener() {
        Map sessionMap = this.getFacesContext().getExternalContext().getSessionMap();
        SessionListener sessionListener = (SessionListener)sessionMap.get(SessionListener.class.getName());
        if (sessionListener == null) {
            sessionListener = new SessionListener();
            sessionMap.put(SessionListener.class.getName(), sessionListener);
        }
        return sessionListener;
    }

    @Generated
    PreDestroyViewMapListener getPreDestroyViewMapListener() {
        return this.preDestroyViewMapListener;
    }

    static class DestructionCallbackWrapper {
        private final String beanName;
        private Runnable callback;

        DestructionCallbackWrapper(String beanName, Runnable callback) {
            Assert.hasText((String)beanName, (String)"beanName must not be null or empty");
            Assert.notNull((Object)callback, (String)"callback must not be null");
            this.beanName = beanName;
            this.callback = callback;
        }

        void onViewDestroy() {
            this.doRunCallback(false);
        }

        void onSessionDestroy() {
            this.doRunCallback(true);
        }

        private synchronized void doRunCallback(boolean session) {
            if (this.callback != null) {
                log.debug("Calling destruction callbacks for bean {} because the {} is destroyed", (Object)this.getBeanName(), (Object)(session ? "session" : "view map"));
                this.callback.run();
                this.callback = null;
            }
        }

        boolean isCallbackCalled() {
            return this.callback == null;
        }

        @Generated
        public String getBeanName() {
            return this.beanName;
        }
    }

    class PreDestroyViewMapListener
    implements ViewMapListener {
        PreDestroyViewMapListener() {
        }

        public void processEvent(SystemEvent event) {
            UIViewRoot root = (UIViewRoot)event.getSource();
            for (Object object : root.getViewMap(false).values()) {
                if (!(object instanceof DestructionCallbackWrapper)) continue;
                ((DestructionCallbackWrapper)object).onViewDestroy();
            }
            ViewScope.this.getSessionListener().cleanup();
        }

        public boolean isListenerForSource(Object source) {
            return source instanceof UIViewRoot;
        }
    }

    static class SessionListener
    implements HttpSessionBindingListener {
        private List<DestructionCallbackWrapper> destructionCallbackWrappers = new LinkedList<DestructionCallbackWrapper>();

        SessionListener() {
        }

        void register(DestructionCallbackWrapper destructionCallbackWrapper) {
            this.cleanup();
            this.destructionCallbackWrappers.add(destructionCallbackWrapper);
        }

        void unregister(DestructionCallbackWrapper destructionCallbackWrapper) {
            this.cleanup();
            this.destructionCallbackWrappers.remove(destructionCallbackWrapper);
        }

        synchronized void cleanup() {
            Iterator<DestructionCallbackWrapper> iterator = this.destructionCallbackWrappers.iterator();
            while (iterator.hasNext()) {
                DestructionCallbackWrapper destructionCallbackWrapper = iterator.next();
                if (!destructionCallbackWrapper.isCallbackCalled()) continue;
                iterator.remove();
            }
        }

        public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        }

        public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
            for (DestructionCallbackWrapper destructionCallbackWrapper : this.destructionCallbackWrappers) {
                destructionCallbackWrapper.onSessionDestroy();
            }
            this.cleanup();
        }

        @Generated
        public List<DestructionCallbackWrapper> getDestructionCallbackWrappers() {
            return this.destructionCallbackWrappers;
        }
    }
}

