/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client.command;

import java.lang.reflect.InvocationTargetException;
import org.jolokia.jvmagent.client.command.AbstractBaseCommand;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.VirtualMachineHandlerOperations;
import org.jolokia.server.core.Version;
import org.jolokia.server.core.config.ConfigKey;

public class HelpCommand
extends AbstractBaseCommand {
    @Override
    String getName() {
        return "help";
    }

    @Override
    int execute(OptionsAndArgs pOpts, Object pVm, VirtualMachineHandlerOperations pHandler) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        HelpCommand.printUsage();
        return 0;
    }

    static void printUsage() {
        String jar = OptionsAndArgs.lookupJarFile().getName();
        System.out.println("Jolokia Agent Launcher\n======================\n\nUsage: java -jar " + jar + " [options] <command> <pid/regexp>\n\nwhere <command> is one of\n    start     -- Start a Jolokia agent for the process specified\n    stop      -- Stop a Jolokia agent for the process specified\n    status    -- Show status of an (potentially) attached agent\n    toggle    -- Toggle between start/stop (default when no command is given)\n    list      -- List all attachable Java processes (default when no argument is given at all)\n    encrypt   -- Encrypt a password which is given as argument or read from standard input\n\n[options] are used for providing runtime information for attaching the agent:\n\n    --host <host>                   Hostname or IP address to which to bind on\n                                    (default: InetAddress.getLocalHost())\n    --port <port>                   Port to listen on (default: 8778)\n    --agentContext <context>        HTTP Context under which the agent is reachable (default: " + ConfigKey.AGENT_CONTEXT.getDefaultValue() + ")\n    --agentId <agent-id>            VM unique identifier used by this agent (default: autogenerated)\n    --agentDescription <desc>       Agent description\n    --authMode <mode>               Authentication mode: 'basic' (default), 'jaas' or 'delegate'\n    --authMatch <match>             If MultiAuthenticator is used, this config item explains how to combine multiple authenticators\n                                     \"any\" -- at least one authenticator must match (default)\n                                     \"all\" -- all authenticators must match\n    --authClass <class>             Classname of an custom Authenticator which must be loadable from the classpath\n    --authUrl <url>                 URL used for a dispatcher authentication (authMode == delegate)\n    --authPrincipalSpec <spec>      Extractor specification for getting the principal (authMode == delegate)\n    --authIgnoreCerts               Whether to ignore CERTS when doing a dispatching authentication (authMode == delegate)\n    --user <user>                   User used for Basic-Authentication\n    --password <password>           Password used for Basic-Authentication\n    --quiet                         No output. \"status\" will exit with code 0 if the agent is running, 1 otherwise\n    --verbose                       Verbose output\n    --executor <executor>           Executor policy for HTTP Threads to use (default: single)\n                                     \"fixed\"  -- Thread pool with a fixed number of threads (default: 5)\n                                     \"cached\" -- Cached Thread Pool, creates threads on demand\n                                     \"single\" -- Single Thread\n    --threadNamePrefix <prefix>     Thread name prefix that executor will use while creating new thread(s)\n                                    (default: jolokia-)\n    --threadNr <nr threads>         Number of fixed threads if \"fixed\" is used as executor\n    --backlog <backlog>             How many request to keep in the backlog (default: 10)\n    --protocol <http|https>         Protocol which must be either \"http\" or \"https\" (default: http)\n    --keystore <keystore>           Path to keystore (https only)\n    --keystorePassword <pwd>        Password to the keystore (https only)\n    --useSslClientAuthentication    Use client certificate authentication (https only)\n    --secureSocketProtocol <name>   Secure protocol (https only, default: TLS)\n    --keyStoreType <name>           Keystore type (https only, default: JKS)\n    --keyManagerAlgorithm <name>    Key manager algorithm (https only, default: SunX509)\n    --trustManagerAlgorithm <name>  Trust manager algorithm (https only, default: SunX509)\n    --caCert <path>                 Path to a PEM encoded CA cert file (https & sslClientAuth only)\n    --serverCert <path>             Path to a PEM encoded server cert file (https only)\n    --serverKey <path>              Path to a PEM encoded server key file (https only)\n    --serverKeyAlgorithm <algo>     Algorithm to use for decrypting the server key (https only, default: RSA)\n    --clientPrincipal <principal>   Allow only this principal in the client cert (https & sslClientAuth only)\n                                    If supplied multiple times, any one of the clientPrincipals must match\n    --extendedClientCheck <t|f>     Additional validation of client certs for the proper key usage (https & sslClientAuth only)\n    --discoveryEnabled <t|f>        Enable/Disable discovery multicast responses (default: false)\n    --discoveryAgentUrl <url>       The URL to use for answering discovery requests. Will be autodetected if not given.\n    --sslProtocol <protocol>        SSL / TLS protocol to enable, can be provided multiple times\n    --sslCipherSuite <suite>        SSL / TLS cipher suite to enable, can be provided multiple times\n    --debug                         Switch on agent debugging\n    --logHandlerClass <class>       Implementation of org.jolokia.server.core.service.api.LogHandler for logging\n                                    Available classes: org.jolokia.server.core.service.impl.QuietLogHandler\n                                                       org.jolokia.server.core.service.impl.JulLogHandler\n    --debugMaxEntries <nr>          Number of debug entries to keep in memory which can be fetched from the Jolokia MBean\n    --maxDepth <depth>              Maximum number of levels for serialization of beans\n    --maxCollectionSize <size>      Maximum number of element in collections to keep when serializing the response\n    --maxObjects <nr>               Maximum number of objects to consider for serialization\n    --restrictorClass <class>       Classname of an custom restrictor which must be loadable from the classpath\n    --policyLocation <url>          Location of a Jolokia policy file\n    --mbeanQualifier <qualifier>    Qualifier to use when registering Jolokia internal MBeans\n    --canonicalNaming <t|f>         whether to use canonicalName for ObjectNames in 'list' or 'search' (default: true)\n    --includeStackTrace <t|f>       whether to include StackTraces for error messages (default: false)\n    --serializeException <t|f>      whether to add a serialized version of the exception in the Jolokia response (default: false)\n    --config <configfile>           Path to a property file from where to read the configuration\n    --help                          This help documentation\n    --version                       Version of this agent (it's " + Version.getAgentVersion() + " btw :)\n\n<pid/regexp> can be either a numeric process id or a regular expression. A regular expression is matched\nagainst the processes' names (ignoring case) and must be specific enough to select exactly one process.\n\nIf no <command> is given but only a <pid> the state of the Agent will be toggled\nbetween \"start\" and \"stop\"\n\nIf neither <command> nor <pid> is given, a list of Java processes along with their IDs\nis printed\n\nThere are several possible reasons, why attaching to a process can fail:\n   * The UID of this launcher must be the very *same* as the process to attach to. It's not sufficient to be root.\n   * The JVM must have HotSpot enabled and be a JVM 1.6 or later.\n   * It must be a Java process ;-)\n\nFor more documentation please visit www.jolokia.org");
    }
}

