/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class ToolsClassFinder {
    private static final String JAVA_HOME = System.getProperty("java.home");
    private static final File[] TOOLS_JAR_LOCATIONS = new File[]{new File(JAVA_HOME + "/../lib/tools.jar"), new File(JAVA_HOME + "/lib/tools.jar")};

    private ToolsClassFinder() {
    }

    public static Class<?> lookupClass(String pClassName) throws ClassNotFoundException {
        try {
            return Class.forName(pClassName);
        }
        catch (ClassNotFoundException exp) {
            return ToolsClassFinder.lookupInToolsJar(pClassName);
        }
    }

    public static Class<?> lookupInToolsJar(String pClassName) throws ClassNotFoundException {
        Object extraInfo;
        if (JAVA_HOME != null) {
            extraInfo = "JAVA_HOME is " + JAVA_HOME;
            for (File toolsJar : TOOLS_JAR_LOCATIONS) {
                try {
                    if (!toolsJar.exists()) continue;
                    ClassLoader loader = ToolsClassFinder.createClassLoader(toolsJar);
                    return loader.loadClass(pClassName);
                }
                catch (MalformedURLException e) {
                    extraInfo = "Cannot create URL from " + toolsJar;
                }
            }
        } else {
            extraInfo = "No JAVA_HOME set";
        }
        throw new ClassNotFoundException("No tools.jar found (" + (String)extraInfo + ")");
    }

    private static ClassLoader createClassLoader(File toolsJar) throws MalformedURLException {
        final URL[] urls = new URL[]{toolsJar.toURI().toURL()};
        if (System.getSecurityManager() == null) {
            return new URLClassLoader(urls, ToolsClassFinder.getParentClassLoader());
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(urls, ToolsClassFinder.getParentClassLoader());
            }
        });
    }

    private static ClassLoader getParentClassLoader() {
        ClassLoader loader = ToolsClassFinder.class.getClassLoader();
        return loader == null ? ClassLoader.getSystemClassLoader() : loader;
    }
}

