/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.HttpExchange;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jolokia.server.core.util.UserPasswordCallbackHandler;

public class JaasHttpAuthenticator
extends BasicAuthenticator {
    private final ThreadLocal<Subject> subjectThreadLocal = new ThreadLocal();

    public JaasHttpAuthenticator(String pRealm) {
        super(pRealm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Authenticator.Result authenticate(HttpExchange pHttpExchange) {
        try {
            Subject subject;
            Authenticator.Result result = super.authenticate(pHttpExchange);
            if (result instanceof Authenticator.Success && (subject = this.subjectThreadLocal.get()) != null) {
                pHttpExchange.setAttribute("org.jolokia.jaasSubject", subject);
            }
            Authenticator.Result result2 = result;
            return result2;
        }
        finally {
            this.subjectThreadLocal.remove();
        }
    }

    @Override
    public boolean checkCredentials(String pUser, String pPassword) {
        try {
            UserPasswordCallbackHandler handler = new UserPasswordCallbackHandler(pUser, pPassword);
            LoginContext loginContext = this.createLoginContext(this.realm, handler);
            loginContext.login();
            this.subjectThreadLocal.set(loginContext.getSubject());
            return true;
        }
        catch (LoginException e) {
            return false;
        }
    }

    protected LoginContext createLoginContext(String realm, CallbackHandler handler) throws LoginException {
        return new LoginContext(realm, handler);
    }
}

