/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.handler;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpsExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.RuntimeMBeanException;
import javax.security.auth.Subject;
import org.jolokia.json.JSONObject;
import org.jolokia.json.JSONStructure;
import org.jolokia.jvmagent.ParsedUri;
import org.jolokia.jvmagent.handler.HttpExchangeBackChannel;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.http.BackChannel;
import org.jolokia.server.core.http.BackChannelHolder;
import org.jolokia.server.core.http.HttpRequestHandler;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.IoUtil;
import org.jolokia.server.core.util.MimeTypeUtil;

public class JolokiaHttpHandler
implements HttpHandler {
    private final HttpRequestHandler requestHandler;
    private String contextPath;
    private final Pattern contentTypePattern = Pattern.compile(".*;\\s*charset=([^;,]+)\\s*.*");
    private final JolokiaContext jolokiaContext;
    private final Executor backChannelThreadPool = Executors.newCachedThreadPool();

    public JolokiaHttpHandler(JolokiaContext pJolokiaContext) {
        this.jolokiaContext = pJolokiaContext;
        this.contextPath = this.jolokiaContext.getConfig(ConfigKey.AGENT_CONTEXT);
        if (!this.contextPath.endsWith("/")) {
            this.contextPath = this.contextPath + "/";
        }
        this.requestHandler = new HttpRequestHandler(this.jolokiaContext);
    }

    @Override
    public void handle(HttpExchange pHttpExchange) throws IOException {
        try {
            this.checkAuthentication(pHttpExchange);
            Subject subject = (Subject)pHttpExchange.getAttribute("org.jolokia.jaasSubject");
            if (subject != null) {
                this.doHandleAs(subject, pHttpExchange);
            } else {
                this.doHandle(pHttpExchange);
            }
        }
        catch (SecurityException exp) {
            this.sendForbidden(pHttpExchange, exp);
        }
    }

    private void doHandleAs(Subject subject, HttpExchange pHttpExchange) {
        try {
            Subject.doAs(subject, () -> {
                this.doHandle(pHttpExchange);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw new SecurityException("Security exception: " + String.valueOf(e.getCause()), e.getCause());
        }
    }

    protected void checkAuthentication(HttpExchange pHttpExchange) throws SecurityException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandle(HttpExchange pExchange) throws IOException {
        JSONObject json = null;
        URI uri = pExchange.getRequestURI();
        ParsedUri parsedUri = new ParsedUri(uri, this.contextPath);
        try {
            this.prepareBackChannel(pExchange);
            InetSocketAddress address = pExchange.getRemoteAddress();
            String scheme = pExchange instanceof HttpsExchange ? "https" : "http";
            this.requestHandler.checkAccess(scheme, this.getHostName(address), address.getAddress().getHostAddress(), this.extractOriginOrReferer(pExchange));
            String method = pExchange.getRequestMethod();
            this.validateCallbackIfGiven(parsedUri);
            if ("GET".equalsIgnoreCase(method)) {
                this.setHeaders(pExchange);
                json = this.executeGetRequest(parsedUri);
            } else if ("POST".equalsIgnoreCase(method)) {
                this.setHeaders(pExchange);
                json = this.executePostRequest(pExchange, parsedUri);
            } else if ("OPTIONS".equalsIgnoreCase(method)) {
                this.performCorsPreflightCheck(pExchange);
            } else {
                throw new IllegalArgumentException("HTTP Method " + method + " is not supported.");
            }
            if (this.jolokiaContext.isDebug()) {
                this.jolokiaContext.debug("Response: " + String.valueOf(json));
            }
        }
        catch (EmptyResponseException exp) {
            return;
        }
        catch (Throwable exp) {
            json = this.requestHandler.handleThrowable(exp instanceof RuntimeMBeanException ? ((RuntimeMBeanException)exp).getTargetException() : exp);
        }
        finally {
            this.releaseBackChannel();
        }
        this.sendResponse(pExchange, parsedUri, (JSONStructure)json);
    }

    private void prepareBackChannel(HttpExchange pExchange) {
        BackChannelHolder.set((BackChannel)new HttpExchangeBackChannel(pExchange, this.backChannelThreadPool));
    }

    private void releaseBackChannel() {
        BackChannelHolder.remove();
    }

    private void validateCallbackIfGiven(ParsedUri pUri) {
        String callback = pUri.getParameter(ConfigKey.CALLBACK.getKeyValue());
        if (callback != null && !MimeTypeUtil.isValidCallback((String)callback)) {
            throw new IllegalArgumentException("Invalid callback name given, which must be a valid javascript function name");
        }
    }

    private String extractOriginOrReferer(HttpExchange pExchange) {
        Headers headers = pExchange.getRequestHeaders();
        String origin = headers.getFirst("Origin");
        if (origin == null) {
            origin = headers.getFirst("Referer");
        }
        return origin != null ? origin.replaceAll("[\\n\\r]*", "") : null;
    }

    private String getHostName(InetSocketAddress address) {
        return Boolean.parseBoolean(this.jolokiaContext.getConfig(ConfigKey.ALLOW_DNS_REVERSE_LOOKUP)) ? address.getHostName() : null;
    }

    private JSONStructure executeGetRequest(ParsedUri parsedUri) throws EmptyResponseException {
        return this.requestHandler.handleGetRequest(parsedUri.getUri().toString(), parsedUri.getPathInfo(), parsedUri.getParameterMap());
    }

    private JSONStructure executePostRequest(HttpExchange pExchange, ParsedUri pUri) throws IOException, EmptyResponseException {
        Matcher matcher;
        String encoding = null;
        Headers headers = pExchange.getRequestHeaders();
        String cType = headers.getFirst("Content-Type");
        if (cType != null && (matcher = this.contentTypePattern.matcher(cType)).matches()) {
            encoding = matcher.group(1);
        }
        InputStream is = pExchange.getRequestBody();
        return this.requestHandler.handlePostRequest(pUri.toString(), is, encoding, pUri.getParameterMap());
    }

    private void performCorsPreflightCheck(HttpExchange pExchange) {
        Headers requestHeaders = pExchange.getRequestHeaders();
        Map respHeaders = this.requestHandler.handleCorsPreflightRequest(this.extractOriginOrReferer(pExchange), requestHeaders.getFirst("Access-Control-Request-Headers"));
        Headers responseHeaders = pExchange.getResponseHeaders();
        for (Map.Entry entry : respHeaders.entrySet()) {
            responseHeaders.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setHeaders(HttpExchange pExchange) {
        String origin = this.requestHandler.extractCorsOrigin(pExchange.getRequestHeaders().getFirst("Origin"));
        Headers headers = pExchange.getResponseHeaders();
        if (origin != null) {
            headers.set("Access-Control-Allow-Origin", origin);
            headers.set("Access-Control-Allow-Credentials", "true");
        }
        headers.set("Cache-Control", "no-cache");
        headers.set("Pragma", "no-cache");
        Calendar cal = Calendar.getInstance();
        headers.set("Date", this.formatHeaderDate(cal.getTime()));
        cal.add(10, -1);
        headers.set("Expires", this.formatHeaderDate(cal.getTime()));
    }

    private void sendForbidden(HttpExchange pExchange, SecurityException securityException) throws IOException {
        Object response = "403 (Forbidden)\n";
        if (securityException != null && securityException.getMessage() != null) {
            response = (String)response + "\n" + securityException.getMessage() + "\n";
        }
        pExchange.sendResponseHeaders(403, ((String)response).length());
        OutputStream os = pExchange.getResponseBody();
        os.write(((String)response).getBytes());
        os.close();
    }

    private void sendResponse(HttpExchange pExchange, ParsedUri pParsedUri, JSONStructure pJson) throws IOException {
        boolean streaming = Boolean.parseBoolean(this.jolokiaContext.getConfig(ConfigKey.STREAMING));
        if (streaming) {
            this.sendStreamingResponse(pExchange, pParsedUri, pJson);
        } else {
            this.sendAllJSON(pExchange, pParsedUri, pJson);
        }
    }

    private void sendStreamingResponse(HttpExchange pExchange, ParsedUri pParsedUri, JSONStructure pJson) throws IOException {
        Headers headers = pExchange.getResponseHeaders();
        if (pJson != null) {
            headers.set("Content-Type", this.getMimeType(pParsedUri) + "; charset=utf-8");
            pExchange.sendResponseHeaders(200, 0L);
            OutputStreamWriter writer = new OutputStreamWriter(pExchange.getResponseBody(), StandardCharsets.UTF_8);
            String callback = pParsedUri.getParameter(ConfigKey.CALLBACK.getKeyValue());
            IoUtil.streamResponseAndClose((Writer)writer, (JSONStructure)pJson, callback != null && MimeTypeUtil.isValidCallback((String)callback) ? callback : null);
        } else {
            headers.set("Content-Type", "text/plain");
            pExchange.sendResponseHeaders(200, -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllJSON(HttpExchange pExchange, ParsedUri pParsedUri, JSONStructure pJson) throws IOException {
        try (OutputStream out = null;){
            Headers headers = pExchange.getResponseHeaders();
            if (pJson != null) {
                headers.set("Content-Type", this.getMimeType(pParsedUri) + "; charset=utf-8");
                String json = pJson.toJSONString();
                String callback = pParsedUri.getParameter(ConfigKey.CALLBACK.getKeyValue());
                String content = callback != null && MimeTypeUtil.isValidCallback((String)callback) ? callback + "(" + json + ");" : json;
                byte[] response = content.getBytes(StandardCharsets.UTF_8);
                pExchange.sendResponseHeaders(200, response.length);
                out = pExchange.getResponseBody();
                out.write(response);
            } else {
                headers.set("Content-Type", "text/plain");
                pExchange.sendResponseHeaders(200, -1L);
            }
        }
    }

    private String getMimeType(ParsedUri pParsedUri) {
        return MimeTypeUtil.getResponseMimeType((String)pParsedUri.getParameter(ConfigKey.MIME_TYPE.getKeyValue()), (String)this.jolokiaContext.getConfig(ConfigKey.MIME_TYPE), (String)pParsedUri.getParameter(ConfigKey.CALLBACK.getKeyValue()));
    }

    private String formatHeaderDate(Date date) {
        SimpleDateFormat rfc1123Format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        rfc1123Format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return rfc1123Format.format(date);
    }
}

