/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.list;

import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.json.JSONObject;
import org.jolokia.service.jmx.api.CacheKeyProvider;
import org.jolokia.service.jmx.handler.list.AttributeDataUpdater;
import org.jolokia.service.jmx.handler.list.ClassNameDataUpdater;
import org.jolokia.service.jmx.handler.list.DataKeys;
import org.jolokia.service.jmx.handler.list.DataUpdater;
import org.jolokia.service.jmx.handler.list.DescriptionDataUpdater;
import org.jolokia.service.jmx.handler.list.ListKeysDataUpdater;
import org.jolokia.service.jmx.handler.list.NotificationDataUpdater;
import org.jolokia.service.jmx.handler.list.OperationDataUpdater;

public class MBeanInfoData {
    private final int maxDepth;
    private final Deque<String> pathStack;
    private final Map<String, Object> infoMap = new JSONObject();
    private static final Map<String, DataUpdater> UPDATERS = new HashMap<String, DataUpdater>();
    private static final DataUpdater LIST_KEYS_UPDATER = new ListKeysDataUpdater();
    private final boolean useCanonicalName;
    private final boolean listKeys;
    private final boolean listCache;
    private final String pProvider;

    public MBeanInfoData(int pMaxDepth, Deque<String> pPathStack, boolean pUseCanonicalName, boolean pListKeys, boolean pListCache, String pProvider) {
        this.maxDepth = pMaxDepth;
        this.useCanonicalName = pUseCanonicalName;
        this.listKeys = pListKeys;
        this.listCache = pListCache;
        this.pathStack = pPathStack != null ? new LinkedList<String>(pPathStack) : new LinkedList();
        this.pProvider = pProvider;
    }

    public boolean handleFirstOrSecondLevel(ObjectName pName) {
        if (this.maxDepth == 1 && this.pathStack.isEmpty()) {
            this.infoMap.put(this.addProviderIfNeeded(pName.getDomain()), 1);
            return true;
        }
        if (this.maxDepth == 2 && this.pathStack.isEmpty()) {
            Map<String, Object> domain = this.getOrCreateJSONObject(this.infoMap, this.addProviderIfNeeded(pName.getDomain()));
            domain.put(this.getKeyPropertyString(pName), 1);
            return true;
        }
        return false;
    }

    private String getKeyPropertyString(ObjectName pName) {
        return this.useCanonicalName ? pName.getCanonicalKeyPropertyListString() : pName.getKeyPropertyListString();
    }

    public void addMBeanInfo(MBeanServerConnection pConn, ObjectInstance pInstance, Set<DataUpdater> customUpdaters, Set<CacheKeyProvider> cacheKeyProviders) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        Map<String, Object> domain;
        ObjectName objectName = pInstance.getObjectName();
        MBeanInfo mBeanInfo = pConn.getMBeanInfo(objectName);
        String domainName = this.addProviderIfNeeded(objectName.getDomain());
        String mbeanKeyListing = this.getKeyPropertyString(objectName);
        Deque<String> stack = this.truncatePathStack(2);
        Map<String, Object> cache = null;
        Map<String, Object> mbean = null;
        if (this.listCache && stack.isEmpty()) {
            cache = this.getOrCreateJSONObject(this.infoMap, "cache");
            Map<String, Object> domains = this.getOrCreateJSONObject(this.infoMap, "domains");
            domain = this.getOrCreateJSONObject(domains, domainName);
        } else {
            domain = this.getOrCreateJSONObject(this.infoMap, domainName);
            mbean = this.getOrCreateJSONObject(domain, mbeanKeyListing);
        }
        if (stack.isEmpty()) {
            if (!this.listCache) {
                this.addFullMBeanInfo(mbean, objectName, mBeanInfo, objectName, customUpdaters);
            } else {
                CacheKeyProvider provider;
                String key = null;
                Iterator<CacheKeyProvider> iterator = cacheKeyProviders.iterator();
                while (iterator.hasNext() && (key = (provider = iterator.next()).determineKey(pInstance)) == null) {
                }
                if (key != null && cache != null) {
                    domain.put(mbeanKeyListing, key);
                    mbean = this.getOrCreateJSONObject(cache, key);
                    if (mbean.isEmpty()) {
                        this.addFullMBeanInfo(mbean, objectName, mBeanInfo, objectName, customUpdaters);
                    }
                } else {
                    mbean = this.getOrCreateJSONObject(domain, mbeanKeyListing);
                    this.addFullMBeanInfo(mbean, objectName, mBeanInfo, objectName, customUpdaters);
                }
            }
        } else {
            this.addPartialMBeanInfo(mbean, objectName, mBeanInfo, objectName, stack);
        }
        if (mbean != null && mbean.isEmpty()) {
            domain.remove(mbeanKeyListing);
            if (domain.isEmpty()) {
                this.infoMap.remove(domainName);
            }
        }
    }

    private String addProviderIfNeeded(String pDomain) {
        return this.pProvider != null ? this.pProvider + "@" + pDomain : pDomain;
    }

    public void handleException(ObjectName pName, IOException pExp) throws IOException {
        if (!this.pathStack.isEmpty()) {
            throw new IOException("IOException for MBean " + String.valueOf(pName) + " (" + pExp.getMessage() + ")", pExp);
        }
        this.addException(pName, pExp);
    }

    public void handleException(ObjectName pName, IllegalStateException pExp) {
        if (!this.pathStack.isEmpty()) {
            throw new IllegalStateException("IllegalStateException for MBean " + String.valueOf(pName) + " (" + pExp.getMessage() + ")", pExp);
        }
        this.addException(pName, pExp);
    }

    public void handleException(ObjectName pName, InstanceNotFoundException pExp) throws InstanceNotFoundException {
        if (!this.pathStack.isEmpty()) {
            throw new InstanceNotFoundException("InstanceNotFoundException for MBean " + String.valueOf(pName) + " (" + pExp.getMessage() + ")");
        }
        this.addException(pName, pExp);
    }

    private void addException(ObjectName pName, Exception pExp) {
        Map<String, Object> domain = this.getOrCreateJSONObject(this.infoMap, this.addProviderIfNeeded(pName.getDomain()));
        Map<String, Object> mbean = this.getOrCreateJSONObject(domain, this.getKeyPropertyString(pName));
        mbean.put(DataKeys.ERROR.getKey(), pExp.toString());
    }

    public Object applyPath() {
        Object value = this.navigatePath();
        if (this.maxDepth == 0) {
            return value;
        }
        if (!(value instanceof JSONObject)) {
            return value;
        }
        return this.truncateJSONObject((JSONObject)value, this.maxDepth);
    }

    private void addFullMBeanInfo(Map<String, Object> pMBeanMap, ObjectName pObjectName, MBeanInfo pMBeanInfo, ObjectName pName, Set<DataUpdater> customUpdaters) {
        for (DataUpdater updater : UPDATERS.values()) {
            updater.update(pMBeanMap, pObjectName, pMBeanInfo, null);
        }
        if (this.listKeys) {
            LIST_KEYS_UPDATER.update(pMBeanMap, pObjectName, pMBeanInfo, null);
        }
        for (DataUpdater customUpdater : customUpdaters) {
            customUpdater.update(pMBeanMap, pObjectName, pMBeanInfo, null);
        }
    }

    private void addPartialMBeanInfo(Map<String, Object> pMBeanMap, ObjectName pObjectName, MBeanInfo pMBeanInfo, ObjectName pName, Deque<String> pPathStack) {
        String what = pPathStack.isEmpty() ? null : pPathStack.pop();
        DataUpdater updater = UPDATERS.get(what);
        if (updater == null && "keys".equals(what)) {
            updater = LIST_KEYS_UPDATER;
        }
        if (updater == null) {
            throw new IllegalArgumentException("Illegal path element " + what);
        }
        updater.update(pMBeanMap, pObjectName, pMBeanInfo, pPathStack);
    }

    private Map<String, Object> getOrCreateJSONObject(Map<String, Object> pMap, String pKey) {
        JSONObject nMap = (JSONObject)pMap.get(pKey);
        if (nMap == null) {
            nMap = new JSONObject();
            pMap.put(pKey, nMap);
        }
        return nMap;
    }

    private Object truncateJSONObject(JSONObject pValue, int pMaxDepth) {
        if (pMaxDepth == 0) {
            return 1;
        }
        JSONObject ret = new JSONObject();
        Set entries = pValue.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JSONObject) {
                ret.put(key, this.truncateJSONObject((JSONObject)value, pMaxDepth - 1));
                continue;
            }
            ret.put(key, value);
        }
        return ret;
    }

    private Deque<String> truncatePathStack(int pLevel) {
        if (this.pathStack.size() < pLevel) {
            return new LinkedList<String>();
        }
        LinkedList<String> ret = new LinkedList<String>(this.pathStack);
        for (int i = 0; i < pLevel; ++i) {
            ret.pop();
        }
        return ret;
    }

    private Object navigatePath() {
        JSONObject innerMap = this.infoMap;
        for (int size = this.pathStack.size(); size > 0; --size) {
            Collection<Object> vals = innerMap.values();
            if (vals.isEmpty()) {
                return innerMap;
            }
            if (vals.size() != 1) {
                throw new IllegalStateException("Internal: More than one key found when extracting with path: " + String.valueOf(vals));
            }
            Object value = vals.iterator().next();
            if (size == 1) {
                return value;
            }
            if (!(value instanceof JSONObject)) {
                throw new IllegalStateException("Internal: Value within path extraction must be a Map, not " + String.valueOf(value.getClass()));
            }
            innerMap = (JSONObject)value;
        }
        return innerMap;
    }

    static {
        for (DataUpdater updater : new DataUpdater[]{new DescriptionDataUpdater(), new ClassNameDataUpdater(), new AttributeDataUpdater(), new OperationDataUpdater(), new NotificationDataUpdater()}) {
            UPDATERS.put(updater.getKey(), updater);
        }
    }
}

