/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Collection;
import java.util.Date;
import org.jolokia.jvmagent.security.PKCS1Util;
import org.jolokia.jvmagent.security.asn1.DERBitString;
import org.jolokia.jvmagent.security.asn1.DERDirect;
import org.jolokia.jvmagent.security.asn1.DERInteger;
import org.jolokia.jvmagent.security.asn1.DERNull;
import org.jolokia.jvmagent.security.asn1.DERObject;
import org.jolokia.jvmagent.security.asn1.DERObjectIdentifier;
import org.jolokia.jvmagent.security.asn1.DEROctetString;
import org.jolokia.jvmagent.security.asn1.DERSequence;
import org.jolokia.jvmagent.security.asn1.DERSet;
import org.jolokia.jvmagent.security.asn1.DERTaggedObject;
import org.jolokia.jvmagent.security.asn1.DERUtcTime;
import org.jolokia.server.core.Version;
import org.jolokia.server.core.util.Base64Util;

public class KeyStoreUtil {
    private KeyStoreUtil() {
    }

    public static void updateWithCaPem(KeyStore pTrustStore, File pCaCert) throws IOException, CertificateException, KeyStoreException {
        try (FileInputStream is = new FileInputStream(pCaCert);){
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            Collection<? extends Certificate> certificates = certFactory.generateCertificates(is);
            for (Certificate certificate : certificates) {
                X509Certificate cert = (X509Certificate)certificate;
                Object alias = cert.getSubjectX500Principal().getName();
                String sid = cert.getSerialNumber().toString();
                if (sid != null) {
                    alias = (String)alias + "|" + sid;
                }
                pTrustStore.setCertificateEntry((String)alias, cert);
            }
        }
    }

    public static void updateWithServerPems(KeyStore pKeyStore, File pServerCert, File pServerKey, String pKeyAlgo, char[] pPassword) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        try (FileInputStream is = new FileInputStream(pServerCert);){
            PrivateKey privateKey;
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            Certificate[] certificates = certFactory.generateCertificates(is).toArray(new Certificate[1]);
            byte[] keyBytes = KeyStoreUtil.decodePem(pServerKey);
            KeyFactory keyFactory = KeyFactory.getInstance(pKeyAlgo);
            try {
                privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
            }
            catch (InvalidKeySpecException e) {
                RSAPrivateCrtKeySpec keySpec = PKCS1Util.decodePKCS1(keyBytes);
                privateKey = keyFactory.generatePrivate(keySpec);
            }
            String alias = ((X509Certificate)certificates[0]).getSubjectX500Principal().getName();
            pKeyStore.setKeyEntry(alias, privateKey, pPassword, certificates);
        }
    }

    public static void updateWithSelfSignedServerCertificate(KeyStore pKeyStore) throws NoSuchAlgorithmException, KeyStoreException {
        String[] certAttributes = new String[]{"Jolokia Agent " + Version.getAgentVersion(), "JVM", "jolokia.org", "Pegnitz", "Franconia", "DE"};
        KeyPair keypair = KeyStoreUtil.createKeyPair();
        PrivateKey privKey = keypair.getPrivate();
        Certificate[] chain = new X509Certificate[]{KeyStoreUtil.getSelfCertificate(keypair, certAttributes, new Date(), 315360000L)};
        pKeyStore.setKeyEntry("jolokia-agent", privKey, new char[0], chain);
    }

    private static KeyPair createKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        return kpg.generateKeyPair();
    }

    private static X509Certificate getSelfCertificate(KeyPair keypair, String[] attributes, Date date, long l) {
        DERTaggedObject version = new DERTaggedObject(DERTaggedObject.TagClass.ContextSpecific, false, 0, new DERInteger(2));
        DERInteger serialNumber = new DERInteger(85165814);
        DERSequence signature = new DERSequence(new DERObject[]{new DERObjectIdentifier("1.2.840.113549.1.1.5"), new DERNull()});
        DERSequence issuerAndSubject = new DERSequence(new DERObject[]{new DERSet(new DERObject[]{new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.4.6"), new DEROctetString(19, attributes[5])})}), new DERSet(new DERObject[]{new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.4.8"), new DEROctetString(19, attributes[4])})}), new DERSet(new DERObject[]{new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.4.7"), new DEROctetString(19, attributes[3])})}), new DERSet(new DERObject[]{new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.4.10"), new DEROctetString(19, attributes[2])})}), new DERSet(new DERObject[]{new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.4.11"), new DEROctetString(19, attributes[1])})}), new DERSet(new DERObject[]{new DERSequence(new DERObject[]{new DERObjectIdentifier("2.5.4.3"), new DEROctetString(19, attributes[0])})})});
        DERSequence validity = new DERSequence(new DERObject[]{new DERUtcTime(date), new DERUtcTime(new Date(date.getTime() + l))});
        DERSequence tbsCertificate = new DERSequence(new DERObject[]{version, serialNumber, signature, issuerAndSubject, validity, issuerAndSubject, new DERDirect(keypair.getPublic().getEncoded())});
        try {
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initSign(keypair.getPrivate(), SecureRandom.getInstance("SHA1PRNG"));
            sig.update(tbsCertificate.getEncoded());
            byte[] signatureBytes = sig.sign();
            DERSequence certificate = new DERSequence(new DERObject[]{tbsCertificate, new DERSequence(new DERObject[]{new DERObjectIdentifier("1.2.840.113549.1.1.5"), new DERNull()}), new DERBitString(signatureBytes)});
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certificate.getEncoded()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException e) {
            throw new IllegalStateException("The getSelfCertificate-method threw an error.", e);
        }
    }

    private static byte[] decodePem(File pemFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(pemFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("-----BEGIN ")) continue;
                byte[] byArray = KeyStoreUtil.readBytes(pemFile, reader, line.trim().replace("BEGIN", "END"));
                return byArray;
            }
            throw new IOException("PEM " + String.valueOf(pemFile) + " is invalid: no begin marker");
        }
    }

    private static byte[] readBytes(File pemFile, BufferedReader reader, String endMarker) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (line.contains(endMarker)) {
                return Base64Util.decode((String)buf.toString());
            }
            buf.append(line.trim());
        }
        throw new IOException(String.valueOf(pemFile) + " is invalid : No end marker");
    }
}

