/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.discovery;

import java.io.IOException;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.service.api.AbstractJolokiaService;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaService;
import org.jolokia.server.core.util.NetworkUtil;
import org.jolokia.service.discovery.MulticastSocketListenerThread;

public class DiscoveryMulticastResponder
extends AbstractJolokiaService<JolokiaService.Init>
implements JolokiaService.Init {
    private MulticastSocketListenerThread listenerThread;

    public DiscoveryMulticastResponder() {
        super(JolokiaService.Init.class, 0);
    }

    @Override
    public void init(JolokiaContext pContext) {
        if (this.discoveryEnabled(pContext) && this.listenerThread == null) {
            if (!NetworkUtil.isMulticastSupported()) {
                pContext.info("Multicast is not supported");
                return;
            }
            String multicastBindAddress = pContext.getConfig(ConfigKey.MULTICAST_BIND_ADDRESS);
            try {
                pContext.debug("Creating MulticastSocketListenerThread for address " + multicastBindAddress);
                MulticastSocketListenerThread thread = new MulticastSocketListenerThread(multicastBindAddress, pContext);
                thread.start();
                this.listenerThread = thread;
            }
            catch (IOException e) {
                pContext.error("Cannot start multicast discovery listener thread on " + multicastBindAddress + ": " + String.valueOf(e), e);
            }
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.listenerThread != null) {
            this.listenerThread.shutdown();
            this.listenerThread = null;
        }
    }

    private boolean discoveryEnabled(JolokiaContext pJolokiaContext) {
        return pJolokiaContext.getConfig(ConfigKey.DISCOVERY_ENABLED) != null && Boolean.parseBoolean(pJolokiaContext.getConfig(ConfigKey.DISCOVERY_ENABLED)) || pJolokiaContext.getConfig(ConfigKey.DISCOVERY_AGENT_URL) != null;
    }
}

