/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security;

import java.math.BigInteger;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.jolokia.jvmagent.security.asn1.DERInteger;
import org.jolokia.jvmagent.security.asn1.DERObject;
import org.jolokia.jvmagent.security.asn1.DERSequence;
import org.jolokia.jvmagent.security.asn1.DERUtils;

class PKCS1Util {
    private PKCS1Util() {
    }

    public static KeySpec decodePKCS1PublicKey(byte[] keyBytes) {
        DERSequence seq = (DERSequence)DERUtils.parse(keyBytes);
        DERObject v1 = seq.getValues()[0];
        DERObject v2 = seq.getValues()[1];
        if (v1 instanceof DERInteger && v2 instanceof DERInteger) {
            return new RSAPublicKeySpec(((DERInteger)v1).asBigInteger(), ((DERInteger)v2).asBigInteger());
        }
        return new X509EncodedKeySpec(keyBytes);
    }

    public static RSAPrivateCrtKeySpec decodePKCS1(byte[] keyBytes) {
        DERSequence seq = (DERSequence)DERUtils.parse(keyBytes);
        BigInteger version = ((DERInteger)seq.getValues()[0]).asBigInteger();
        BigInteger modulus = ((DERInteger)seq.getValues()[1]).asBigInteger();
        BigInteger publicExponent = ((DERInteger)seq.getValues()[2]).asBigInteger();
        BigInteger privateExponent = ((DERInteger)seq.getValues()[3]).asBigInteger();
        BigInteger primeP = ((DERInteger)seq.getValues()[4]).asBigInteger();
        BigInteger primeQ = ((DERInteger)seq.getValues()[5]).asBigInteger();
        BigInteger primeExponentP = ((DERInteger)seq.getValues()[6]).asBigInteger();
        BigInteger primeExponentQ = ((DERInteger)seq.getValues()[7]).asBigInteger();
        BigInteger crtCoefficient = ((DERInteger)seq.getValues()[8]).asBigInteger();
        return new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
    }
}

