/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.request;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.client.request.AbtractJ4pMBeanRequest;
import org.jolokia.client.request.J4pReadResponse;
import org.jolokia.client.request.J4pTargetConfig;
import org.jolokia.client.request.J4pType;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class J4pReadRequest
extends AbtractJ4pMBeanRequest {
    private final List<String> attributes;
    private String path;

    public J4pReadRequest(ObjectName pObjectName, String ... pAttribute) {
        this(null, pObjectName, pAttribute);
    }

    public J4pReadRequest(J4pTargetConfig pTargetConfig, ObjectName pObjectName, String ... pAttribute) {
        super(J4pType.READ, pObjectName, pTargetConfig);
        this.attributes = Arrays.asList(pAttribute);
    }

    public J4pReadRequest(String pObjectName, String ... pAttribute) throws MalformedObjectNameException {
        this((J4pTargetConfig)null, pObjectName, pAttribute);
    }

    public J4pReadRequest(J4pTargetConfig pTargetConfig, String pObjectName, String ... pAttribute) throws MalformedObjectNameException {
        this(pTargetConfig, new ObjectName(pObjectName), pAttribute);
    }

    public Collection<String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute() {
        if (!this.hasSingleAttribute()) {
            throw new IllegalArgumentException("More than one attribute given for this request");
        }
        return this.attributes.get(0);
    }

    @Override
    List<String> getRequestParts() {
        if (this.hasSingleAttribute()) {
            List<String> ret = super.getRequestParts();
            ret.add(this.getAttribute());
            this.addPath(ret, this.path);
            return ret;
        }
        if (this.hasAllAttributes() && this.path == null) {
            return super.getRequestParts();
        }
        return null;
    }

    @Override
    JSONObject toJson() {
        JSONObject ret = super.toJson();
        if (this.hasSingleAttribute()) {
            ret.put((Object)"attribute", (Object)this.attributes.get(0));
        } else if (!this.hasAllAttributes()) {
            JSONArray attrs = new JSONArray();
            attrs.addAll(this.attributes);
            ret.put((Object)"attribute", (Object)attrs);
        }
        if (this.path != null) {
            ret.put((Object)"path", (Object)this.path);
        }
        return ret;
    }

    J4pReadResponse createResponse(JSONObject pResponse) {
        return new J4pReadResponse(this, pResponse);
    }

    public boolean hasSingleAttribute() {
        return this.attributes.size() == 1;
    }

    public boolean hasAllAttributes() {
        return this.attributes.isEmpty();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String pPath) {
        this.path = pPath;
    }
}

