/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client.util;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.PlatformUtils;
import org.jolokia.jvmagent.client.util.ProcessDescription;
import org.jolokia.jvmagent.client.util.ProcessingException;
import org.jolokia.jvmagent.client.util.VirtualMachineHandlerOperations;

class DirectVirtualMachineHandler
implements VirtualMachineHandlerOperations {
    private final OptionsAndArgs options;

    DirectVirtualMachineHandler(OptionsAndArgs options) {
        this.options = options;
    }

    @Override
    public Object attachVirtualMachine() throws ProcessingException {
        if (this.options.getPid() == null && this.options.getProcessPattern() == null) {
            return null;
        }
        String pid = PlatformUtils.getProcessId(this, this.options);
        try {
            return VirtualMachine.attach(pid);
        }
        catch (AttachNotSupportedException e) {
            throw new ProcessingException(this.getPidErrorMesssage(pid, "AttachNotSupportedException"), e, this.options);
        }
        catch (IOException e) {
            throw new ProcessingException(this.getPidErrorMesssage(pid, "InvocationTarget"), e, this.options);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessingException("Illegal Argument", e, this.options);
        }
    }

    private String getPidErrorMesssage(String pid, String label) {
        return pid != null ? String.format("Cannot attach to process-ID %s (%s %s).\nSee --help for possible reasons.", pid, label, VirtualMachine.class.getName()) : String.format("%s %s", label, VirtualMachine.class.getName());
    }

    @Override
    public void detachAgent(Object pVm) throws ProcessingException {
        try {
            ((VirtualMachine)pVm).detach();
        }
        catch (IOException e) {
            throw new ProcessingException("Error while detaching", e, this.options);
        }
    }

    @Override
    public List<ProcessDescription> listProcesses() {
        ArrayList<ProcessDescription> ret = new ArrayList<ProcessDescription>();
        for (VirtualMachineDescriptor descriptor : VirtualMachine.list()) {
            ret.add(new ProcessDescription(descriptor.id(), descriptor.displayName()));
        }
        return ret;
    }

    @Override
    public ProcessDescription findProcess(Pattern pPattern) {
        return PlatformUtils.findProcess(pPattern, this.listProcesses());
    }

    @Override
    public void loadAgent(Object pVm, String jarFilePath, String args) {
        try {
            ((VirtualMachine)pVm).loadAgent(jarFilePath, args);
        }
        catch (AgentLoadException e) {
            throw new ProcessingException("Error while loading Jolokia agent to a JVM process", e, this.options);
        }
        catch (AgentInitializationException e) {
            throw new ProcessingException("Error while loading Jolokia agent to a JVM process", e, this.options);
        }
        catch (IOException e) {
            throw new ProcessingException("Error while loading Jolokia agent to a JVM process", e, this.options);
        }
    }

    @Override
    public Properties getSystemProperties(Object pVm) {
        try {
            return ((VirtualMachine)pVm).getSystemProperties();
        }
        catch (IOException e) {
            throw new ProcessingException("Error while getting system properties from a JVM process", e, this.options);
        }
    }
}

