/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.detector.osgi;

import java.util.Dictionary;
import org.jolokia.server.detector.jee.AbstractServerDetector;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class AbstractOsgiServerDetector
extends AbstractServerDetector {
    private final BundleContext context;

    public AbstractOsgiServerDetector(BundleContext pContext, String pName) {
        super(pName, 0);
        this.context = pContext;
    }

    protected String getSystemBundleVersion() {
        Dictionary<?, ?> headers = this.getSystemBundleHeaders();
        return (String)headers.get("Bundle-Version");
    }

    protected String getBundleVersion(String pSymbolicName) {
        for (Bundle bundle : this.context.getBundles()) {
            if (!pSymbolicName.equalsIgnoreCase(bundle.getSymbolicName())) continue;
            Dictionary headers = bundle.getHeaders();
            return (String)headers.get("Bundle-Version");
        }
        return null;
    }

    protected boolean checkSystemBundleForSymbolicName(String pSymbolicName) {
        Dictionary<?, ?> headers = this.getSystemBundleHeaders();
        if (headers != null) {
            String name = (String)headers.get("Bundle-SymbolicName");
            return name.startsWith(pSymbolicName);
        }
        return false;
    }

    private Dictionary<?, ?> getSystemBundleHeaders() {
        Bundle systemBundle = this.context.getBundle(0L);
        return systemBundle.getHeaders();
    }
}

