/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.detector.jee;

import java.util.Collections;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jolokia.server.core.detector.DefaultServerHandle;
import org.jolokia.server.core.service.api.ServerHandle;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.server.detector.jee.AbstractServerDetector;

public class WeblogicDetector
extends AbstractServerDetector {
    public WeblogicDetector(int pOrder) {
        super("weblogic", pOrder);
    }

    public ServerHandle detect(MBeanServerAccess pMBeanServerAccess) {
        String domainConfigMBean = this.getSingleStringAttribute(pMBeanServerAccess, "*:Name=RuntimeService,*", "DomainConfiguration");
        if (domainConfigMBean != null) {
            String version = this.getSingleStringAttribute(pMBeanServerAccess, domainConfigMBean, "ConfigurationVersion");
            return new WeblogicServerHandle(version);
        }
        return null;
    }

    @Override
    public Set<MBeanServerConnection> getMBeanServers() {
        if (!this.isJBoss()) {
            try {
                InitialContext ctx = new InitialContext();
                MBeanServerConnection server = (MBeanServerConnection)ctx.lookup("java:comp/env/jmx/runtime");
                if (server != null) {
                    return Collections.singleton(server);
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isJBoss() {
        try {
            Class.forName("org.jboss.mx.util.MBeanServerLocator");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static class WeblogicServerHandle
    extends DefaultServerHandle {
        public WeblogicServerHandle(String version) {
            super("Oracle", "weblogic", version);
        }
    }
}

