/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.history;

import java.lang.management.ManagementFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.security.auth.Subject;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.auth.JolokiaAgentPrincipal;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.service.api.AbstractJolokiaService;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.request.RequestInterceptor;
import org.jolokia.service.history.History;
import org.jolokia.service.history.HistoryStore;

public class HistoryMBeanRequestInterceptor
extends AbstractJolokiaService<RequestInterceptor>
implements RequestInterceptor {
    private ObjectName historyObjectName;

    public HistoryMBeanRequestInterceptor(int pOrderId) {
        super(RequestInterceptor.class, pOrderId);
    }

    public void init(JolokiaContext pCtx) {
        if (this.getJolokiaContext() == null) {
            super.init(pCtx);
            int maxEntries = this.getMaxEntries(pCtx);
            HistoryStore historyStore = new HistoryStore(maxEntries);
            History history = new History(historyStore);
            this.historyObjectName = this.registerJolokiaMBean("jolokia:type=History", history);
        }
    }

    public void destroy() throws Exception {
        if (this.getJolokiaContext() != null) {
            this.unregisterJolokiaMBean(this.historyObjectName);
        }
        super.destroy();
    }

    public void intercept(final JolokiaRequest pJmxReq, final JSONObject pJson) {
        final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (this.historyObjectName != null) {
            try {
                Subject.doAs(JolokiaAgentPrincipal.asSubject(), new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            mBeanServer.invoke(HistoryMBeanRequestInterceptor.this.historyObjectName, "updateAndAdd", new Object[]{pJmxReq, pJson}, new String[]{JolokiaRequest.class.getName(), JSONObject.class.getName()});
                        }
                        catch (InstanceNotFoundException instanceNotFoundException) {
                        }
                        catch (MBeanException e) {
                            throw new IllegalStateException("Internal: Cannot update History store", e);
                        }
                        catch (ReflectionException e) {
                            throw new IllegalStateException("Internal: Cannot call History MBean via reflection", e);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
    }

    private int getMaxEntries(JolokiaContext pCtx) {
        int maxEntries;
        try {
            maxEntries = Integer.parseInt(pCtx.getConfig(ConfigKey.HISTORY_MAX_ENTRIES));
        }
        catch (NumberFormatException exp) {
            maxEntries = Integer.parseInt(ConfigKey.HISTORY_MAX_ENTRIES.getDefaultValue());
        }
        return maxEntries;
    }
}

