/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx;

import java.io.IOException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.JolokiaObjectNameRequest;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.NotChangedException;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.request.AbstractRequestHandler;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.service.jmx.api.CommandHandler;
import org.jolokia.service.jmx.api.CommandHandlerManager;

public class LocalRequestHandler
extends AbstractRequestHandler {
    private CommandHandlerManager commandHandlerManager;
    private JolokiaContext jolokiaContext;

    public LocalRequestHandler(int pOrder) {
        super("jmx", pOrder);
    }

    public void init(JolokiaContext pCtx) {
        this.commandHandlerManager = new CommandHandlerManager(pCtx);
        this.jolokiaContext = pCtx;
    }

    public boolean canHandle(JolokiaRequest pJolokiaRequest) {
        if (pJolokiaRequest instanceof JolokiaObjectNameRequest) {
            JolokiaObjectNameRequest oReq = (JolokiaObjectNameRequest)pJolokiaRequest;
            return oReq.getProvider() == null || this.checkProvider((JolokiaRequest)oReq);
        }
        return true;
    }

    public <R extends JolokiaRequest> Object handleRequest(R pJmxReq, Object pPreviousResult) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, NotChangedException, EmptyResponseException {
        CommandHandler<R> handler = this.commandHandlerManager.getCommandHandler(pJmxReq.getType());
        if (handler.handleAllServersAtOnce(pJmxReq)) {
            try {
                return handler.handleAllServerRequest(this.jolokiaContext.getMBeanServerAccess(), pJmxReq, pPreviousResult);
            }
            catch (IOException e) {
                throw new IllegalStateException("Internal: IOException " + e + ". Shouldn't happen.", e);
            }
        }
        return this.handleRequest(handler, pJmxReq);
    }

    public void destroy() throws JMException {
        this.commandHandlerManager.destroy();
    }

    private <R extends JolokiaRequest> Object handleRequest(CommandHandler<R> pRequestHandler, R pJmxReq) throws MBeanException, ReflectionException, AttributeNotFoundException, InstanceNotFoundException, NotChangedException, EmptyResponseException {
        AttributeNotFoundException attrException = null;
        InstanceNotFoundException objNotFoundException = null;
        MBeanServerAccess executor = this.jolokiaContext.getMBeanServerAccess();
        for (MBeanServerConnection conn : executor.getMBeanServers()) {
            try {
                return pRequestHandler.handleSingleServerRequest(conn, pJmxReq);
            }
            catch (InstanceNotFoundException exp) {
                objNotFoundException = exp;
            }
            catch (AttributeNotFoundException exp) {
                attrException = exp;
            }
            catch (IOException exp) {
                throw new IllegalStateException("I/O Error while dispatching", exp);
            }
        }
        if (attrException != null) {
            throw attrException;
        }
        throw objNotFoundException;
    }
}

