/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json.simplifier;

import org.jolokia.service.serializer.json.simplifier.SimplifierExtractor;

public class ClassSimplifier
extends SimplifierExtractor<Class> {
    public ClassSimplifier() {
        super(Class.class);
        Object[][] pAttrs = new Object[][]{{"name", new NameAttributeExtractor()}, {"interfaces", new InterfaceAttributeExtractor()}};
        this.addExtractors(pAttrs);
    }

    private static class InterfaceAttributeExtractor
    implements SimplifierExtractor.AttributeExtractor<Class> {
        private InterfaceAttributeExtractor() {
        }

        @Override
        public Object extract(Class value) throws SimplifierExtractor.AttributeExtractor.SkipAttributeException {
            if (value.isInterface()) {
                throw new SimplifierExtractor.AttributeExtractor.SkipAttributeException();
            }
            return value.getInterfaces();
        }
    }

    private static class NameAttributeExtractor
    implements SimplifierExtractor.AttributeExtractor<Class> {
        private NameAttributeExtractor() {
        }

        @Override
        public Object extract(Class pClass) {
            return pClass.getName();
        }
    }
}

