/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.jolokia.server.core.service.serializer.SerializeOptions;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;

class ObjectSerializationContext {
    private static final Set<Class> SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(String.class, Number.class, Long.class, Integer.class, Boolean.class, Date.class));
    private final Set<Object> objectsInCallStack = new HashSet<Object>();
    private final Stack<Object> callStack = new Stack();
    private final SerializeOptions options;
    private int objectCount = 0;

    ObjectSerializationContext(SerializeOptions pOpts) {
        this.options = pOpts;
    }

    boolean alreadyVisited(Object object) {
        return this.objectsInCallStack.contains(object);
    }

    public boolean maxDepthReached() {
        return this.options.maxDepthReached(this.objectsInCallStack.size());
    }

    public boolean maxObjectsExceeded() {
        return this.options.maxObjectExceeded(this.objectCount);
    }

    public int getCollectionSizeTruncated(int pCollectionSize) {
        return this.options.getCollectionSizeTruncated(pCollectionSize);
    }

    public String getSerializeLong() {
        return this.options.getSerializeLong();
    }

    public ValueFaultHandler getValueFaultHandler() {
        return this.options.getValueFaultHandler();
    }

    void push(Object object) {
        this.callStack.push(object);
        if (object != null && !SIMPLE_TYPES.contains(object.getClass())) {
            this.objectsInCallStack.add(object);
        }
        ++this.objectCount;
    }

    Object pop() {
        Object ret = this.callStack.pop();
        if (ret != null && !SIMPLE_TYPES.contains(ret.getClass())) {
            this.objectsInCallStack.remove(ret);
        }
        return ret;
    }
}

