/*
 * Copyright 2009-2011 Roland Huss
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.jolokia.service.serializer.object;

import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

/**
 * Converter used for {@link SimpleType}. It simply delegates to
 * {@link org.jolokia.service.serializer.json.ObjectToJsonConverter}
 *
 * @author roland
 * @since 28.09.11
 */
class SimpleTypeConverter extends OpenTypeConverter<SimpleType<?>> {

    private final Converter<String> objectToObjectConverter;

    /**
     * Constructor
     *
     * @param pObjectToOpenTypeConverter    parent converter (not used here, because simple types do not contain other
     *                                 values)
     * @param pObjectToObjectConverter object to object converter for transforming simple types
     */
    SimpleTypeConverter(ObjectToOpenTypeConverter pObjectToOpenTypeConverter, Converter<String> pObjectToObjectConverter) {
        super(pObjectToOpenTypeConverter);
        objectToObjectConverter = pObjectToObjectConverter;
    }

    @Override
    boolean canConvert(OpenType<?> pType) {
        return pType instanceof SimpleType;
    }

    @Override
    public Object convert(SimpleType<?> pType, Object pFrom) {
        return objectToObjectConverter.convert(pType.getClassName(), pFrom);
    }

}
