/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.jolokia.jvmagent.JolokiaServer;
import org.jolokia.jvmagent.JolokiaServerConfig;
import org.jolokia.jvmagent.spring.SpringJolokiaConfigHolder;
import org.jolokia.jvmagent.spring.SystemPropertyMode;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.OrderComparator;

public class SpringJolokiaAgent
extends JolokiaServer
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private SpringJolokiaConfigHolder config;
    private boolean lookupConfig = false;
    private SystemPropertyMode systemPropertyMode;
    private ApplicationContext context;

    public void afterPropertiesSet() throws IOException {
        HashMap<String, String> finalConfig = new HashMap<String, String>();
        if (this.systemPropertyMode == SystemPropertyMode.MODE_FALLBACK) {
            finalConfig.putAll(this.lookupSystemProperties());
        }
        if (this.config != null) {
            finalConfig.putAll(this.config.getConfig());
        }
        if (this.lookupConfig) {
            Map configsMap = this.context.getBeansOfType(SpringJolokiaConfigHolder.class);
            ArrayList configs = new ArrayList(configsMap.values());
            Collections.sort(configs, new OrderComparator());
            for (SpringJolokiaConfigHolder c : configs) {
                if (c == this.config) continue;
                finalConfig.putAll(c.getConfig());
            }
        }
        if (this.systemPropertyMode == SystemPropertyMode.MODE_OVERRIDE) {
            finalConfig.putAll(this.lookupSystemProperties());
        }
        String autoStartS = (String)finalConfig.remove("autoStart");
        boolean autoStart = true;
        if (autoStartS != null) {
            autoStart = Boolean.parseBoolean(autoStartS);
        }
        this.init(new JolokiaServerConfig(finalConfig), false);
        if (autoStart) {
            this.start();
        }
    }

    private Map<String, String> lookupSystemProperties() {
        HashMap<String, String> ret = new HashMap<String, String>();
        Enumeration<?> propEnum = System.getProperties().propertyNames();
        while (propEnum.hasMoreElements()) {
            String prop = (String)propEnum.nextElement();
            if (!prop.startsWith("jolokia.")) continue;
            String key = prop.substring("jolokia.".length());
            ret.put(key, System.getProperty(prop));
        }
        return ret;
    }

    public void destroy() {
        this.stop();
    }

    public void setConfig(SpringJolokiaConfigHolder pConfig) {
        this.config = pConfig;
    }

    public void setLookupConfig(boolean pLookupConfig) {
        this.lookupConfig = pLookupConfig;
    }

    public void setApplicationContext(ApplicationContext pContext) {
        if (this.lookupConfig) {
            this.context = pContext;
        }
    }

    public void setSystemPropertiesMode(String pMode) {
        this.systemPropertyMode = SystemPropertyMode.fromMode(pMode);
        if (this.systemPropertyMode == null) {
            this.systemPropertyMode = SystemPropertyMode.MODE_NEVER;
        }
    }

    public void setId(String pId) {
    }
}

