/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.support.jmx;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.server.core.service.serializer.Serializer;
import org.jolokia.support.jmx.JolokiaMBeanServerHandler;
import org.jolokia.support.jmx.JolokiaMBeanServerHolderMBean;

public class JolokiaMBeanServerHolder
implements JolokiaMBeanServerHolderMBean {
    private final MBeanServer jolokiaMBeanServer;
    public static final ObjectName MBEAN_SERVER_HOLDER_OBJECTNAME;

    JolokiaMBeanServerHolder(MBeanServer pJolokiaMBeanServer) {
        this.jolokiaMBeanServer = pJolokiaMBeanServer;
    }

    @Override
    public MBeanServer getJolokiaMBeanServer() {
        return this.jolokiaMBeanServer;
    }

    public static MBeanServer registerJolokiaMBeanServerHolderMBean(MBeanServer pServer, Serializer pSerializer) {
        MBeanServer jolokiaMBeanServer;
        ObjectName holderName = MBEAN_SERVER_HOLDER_OBJECTNAME;
        try {
            jolokiaMBeanServer = JolokiaMBeanServerHolder.createJolokiaMBeanServer(pSerializer);
            JolokiaMBeanServerHolder holder = new JolokiaMBeanServerHolder(jolokiaMBeanServer);
            pServer.registerMBean(holder, holderName);
        }
        catch (InstanceAlreadyExistsException e) {
            try {
                jolokiaMBeanServer = (MBeanServer)pServer.getAttribute(holderName, "JolokiaMBeanServer");
            }
            catch (JMException e1) {
                throw new IllegalStateException("Internal: Cannot get JolokiaMBean server in fallback JMX lookup while trying to register the holder MBean: " + e, e);
            }
        }
        catch (JMException e) {
            throw new IllegalStateException("Internal: JolokiaMBeanHolder cannot be registered to JMX: " + e, e);
        }
        return jolokiaMBeanServer;
    }

    private static MBeanServer createJolokiaMBeanServer(Serializer pSerializer) {
        return (MBeanServer)Proxy.newProxyInstance(JolokiaMBeanServerHolder.class.getClassLoader(), new Class[]{MBeanServer.class}, (InvocationHandler)new JolokiaMBeanServerHandler(pSerializer));
    }

    public static void unregisterJolokiaMBeanServerHolderMBean(MBeanServer pMBeanServer) {
        try {
            pMBeanServer.unregisterMBean(MBEAN_SERVER_HOLDER_OBJECTNAME);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (MBeanRegistrationException e) {
            throw new IllegalStateException("Cannot unregister " + MBEAN_SERVER_HOLDER_OBJECTNAME + ": " + e, e);
        }
    }

    static {
        try {
            MBEAN_SERVER_HOLDER_OBJECTNAME = new ObjectName("jolokia:type=MBeanServer");
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name jolokia:type=MBeanServer", e);
        }
    }
}

