/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.support.spring.actuator;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.util.Map;
import org.jolokia.server.core.http.AgentServlet;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletPath;
import org.springframework.boot.web.servlet.ServletContextInitializer;

public class JolokiaServletRegistration
implements ServletContextInitializer {
    private final Map<String, String> initParameters;
    private final DispatcherServletPath dispatcherServletPath;
    private final WebEndpointProperties webEndpointProperties;

    public JolokiaServletRegistration(Map<String, String> initParameters, WebEndpointProperties webEndpointProperties, DispatcherServletPath dispatcherServletPath) {
        this.initParameters = initParameters;
        this.dispatcherServletPath = dispatcherServletPath;
        this.webEndpointProperties = webEndpointProperties;
    }

    public void onStartup(ServletContext servletContext) {
        String basePath = this.dispatcherServletPath.getRelativePath(this.webEndpointProperties.getBasePath());
        ServletRegistration.Dynamic reg = servletContext.addServlet("jolokia", AgentServlet.class);
        reg.setInitParameters(this.initParameters);
        reg.addMapping(new String[]{basePath + "/jolokia/*"});
    }
}

