/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.apitool;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jooby.Jooby;
import org.jooby.MediaType;
import org.jooby.Route;
import org.jooby.apitool.RouteMethod;
import org.jooby.apitool.RouteResponse;
import org.jooby.internal.apitool.BytecodeRouteParser;

public class ApiParser {
    private static final Predicate<RouteMethod> TRUE = r -> true;
    private final Path dir;
    private final Map<Predicate<RouteMethod>, Consumer<RouteMethod>> customizer = new LinkedHashMap<Predicate<RouteMethod>, Consumer<RouteMethod>>();
    private final Predicate<RouteMethod> filter;
    private ClassLoader loader = this.getClass().getClassLoader();

    public ApiParser(Path dir, Predicate<RouteMethod> filter) {
        this.dir = dir;
        this.filter = filter;
    }

    public ApiParser(Path dir) {
        this(dir, TRUE);
    }

    public List<RouteMethod> parseFully(Jooby application) throws Exception {
        List<RouteMethod> methods = this.parseFully(application.getClass().getName(), Jooby.exportRoutes((Jooby)application));
        return methods;
    }

    public Path export(Path outputBaseDir, String application) throws Exception {
        return new BytecodeRouteParser(this.loader, this.dir).export(outputBaseDir, application);
    }

    public List<RouteMethod> parse(String application) throws Exception {
        return new BytecodeRouteParser(this.loader, this.dir).parse(application).stream().filter(this.filter).collect(Collectors.toList());
    }

    public List<RouteMethod> parseFully(String application, List<Route.Definition> routes) throws Exception {
        List<RouteMethod> methods = this.parse(application);
        BiFunction<String, String, OptionalInt> routeIndex = (verb, pattern) -> {
            RouteMethod it = new RouteMethod((String)verb, (String)pattern, new RouteResponse(Void.TYPE));
            return IntStream.range(0, methods.size()).filter(i -> ((RouteMethod)methods.get(i)).equals(it)).findFirst();
        };
        ArrayList<RouteMethod> result = new ArrayList<RouteMethod>(routes.size());
        for (Route.Definition route : routes) {
            routeIndex.apply(route.method(), route.pattern()).ifPresent(i -> result.add(this.complement(route, (RouteMethod)methods.remove(i))));
        }
        this.customizer.entrySet().forEach(it -> result.stream().filter((Predicate)it.getKey()).forEach((Consumer)it.getValue()));
        return result;
    }

    public ApiParser with(ClassLoader loader) {
        this.loader = Objects.requireNonNull(loader, "ClassLoader required.");
        return this;
    }

    public ApiParser modify(Predicate<RouteMethod> matcher, Consumer<RouteMethod> customizer) {
        this.customizer.put(matcher, customizer);
        return this;
    }

    private RouteMethod complement(Route.Definition route, RouteMethod method) {
        method.attributes(route.attributes());
        String name = route.name();
        if (!name.equals("/anonymous")) {
            method.name(name);
        }
        BiConsumer<List, Consumer> types = (values, setter) -> setter.accept(values.stream().map(MediaType::name).filter(it -> !it.equals("*/*")).collect(Collectors.toList()));
        types.accept(route.consumes(), method::consumes);
        types.accept(route.produces(), method::produces);
        return method;
    }
}

