/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.apitool;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RouteResponse {
    private Type type;
    private String description;
    private Map<Integer, String> status;

    public RouteResponse(Type type) {
        this.type(type);
    }

    protected RouteResponse() {
    }

    public Type type() {
        return this.type;
    }

    public RouteResponse type(Type type) {
        this.type = Objects.requireNonNull(type, "Return type required.");
        return this;
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public RouteResponse description(String description) {
        this.description = Strings.emptyToNull((String)description);
        return this;
    }

    public Map<Integer, String> status() {
        return Optional.ofNullable(this.status).orElse((Map<Integer, String>)ImmutableMap.of());
    }

    public int statusCode() {
        return this.status().entrySet().stream().map(it -> (Integer)it.getKey()).filter(code -> code >= 200 && code < 400).findFirst().orElseGet(() -> this.type() == Void.TYPE ? 204 : 200);
    }

    public RouteResponse status(Map<Integer, String> status) {
        if (status != null && this.status == null) {
            this.status = new LinkedHashMap<Integer, String>();
            this.status.putAll(status);
        }
        return this;
    }

    public Optional<String> status(int status) {
        return Optional.ofNullable(this.status().get(status));
    }

    public String toString() {
        return this.type + " => " + this.status();
    }
}

