/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.apitool.raml;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooby.MediaType;
import org.jooby.apitool.raml.RamlParameter;
import org.jooby.apitool.raml.RamlResponse;
import org.jooby.apitool.raml.RamlType;

public class RamlMethod {
    private final transient String name;
    private String displayName;
    private String description;
    private Map<String, RamlParameter> queryParameters;
    private Map<String, RamlParameter> formParameters;
    private Map<String, RamlParameter> headers;
    private RamlType body;
    private List<String> mediaType;
    private Map<Integer, RamlResponse> responses;

    public RamlMethod(String name) {
        this.name = name;
    }

    @JsonIgnore
    public RamlType getBody() {
        return this.body;
    }

    public void setBody(RamlType body) {
        this.body = body;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, RamlParameter> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, RamlParameter> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public Map<String, RamlParameter> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, RamlParameter> headers) {
        this.headers = headers;
    }

    public Map<Integer, RamlResponse> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<Integer, RamlResponse> responses) {
        this.responses = responses;
    }

    @JsonIgnore
    public List<String> getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(List<String> mediaType) {
        this.mediaType = mediaType == null ? null : (mediaType.isEmpty() ? null : mediaType);
    }

    @JsonIgnore
    public Map<String, RamlParameter> getFormParameters() {
        return this.formParameters;
    }

    public void setFormParameters(Map<String, RamlParameter> formParameters) {
        this.formParameters = formParameters;
    }

    public RamlParameter queryParameter(String name) {
        RamlParameter param;
        if (this.queryParameters == null) {
            this.queryParameters = new LinkedHashMap<String, RamlParameter>();
        }
        if ((param = this.queryParameters.get(name)) == null) {
            param = new RamlParameter(name);
            this.queryParameters.put(name, param);
        }
        return param;
    }

    public RamlParameter formParameter(String name) {
        RamlParameter param;
        if (this.formParameters == null) {
            this.formParameters = new LinkedHashMap<String, RamlParameter>();
        }
        if ((param = this.formParameters.get(name)) == null) {
            param = new RamlParameter(name);
            this.formParameters.put(name, param);
        }
        return param;
    }

    public RamlParameter headerParameter(String name) {
        RamlParameter param;
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, RamlParameter>();
        }
        if ((param = this.headers.get(name)) == null) {
            param = new RamlParameter(name);
            this.headers.put(name, param);
        }
        return param;
    }

    public RamlResponse response(Integer status) {
        RamlResponse response;
        if (this.responses == null) {
            this.responses = new LinkedHashMap<Integer, RamlResponse>();
        }
        if ((response = this.responses.get(status)) == null) {
            response = new RamlResponse();
            this.responses.put(status, response);
        }
        return response;
    }

    @JsonAnyGetter
    Map<String, Object> attributes() {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        if (this.formParameters != null) {
            attributes.put("body", ImmutableMap.of((Object)MediaType.multipart.name(), (Object)ImmutableMap.of((Object)"properties", this.formParameters)));
        } else if (this.body != null) {
            if (this.mediaType != null) {
                attributes.put("body", this.mediaType.stream().collect(Collectors.toMap(Function.identity(), it -> this.body.getRef())));
            } else {
                attributes.put("body", this.body.getRef());
            }
        } else if (this.mediaType != null) {
            attributes.put("body", this.mediaType.stream().collect(Collectors.toMap(Function.identity(), it -> ImmutableMap.of())));
        }
        return attributes;
    }
}

