/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.apitool.raml;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.jooby.apitool.raml.RamlMethod;
import org.jooby.apitool.raml.RamlParameter;

public class RamlPath {
    private String displayName;
    private String description;
    private Map<String, RamlMethod> methods;
    private Map<String, RamlPath> resources;
    private Map<String, RamlParameter> uriParameters;

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonAnyGetter
    public Map<String, Object> getChildren() {
        LinkedHashMap<String, Object> children = new LinkedHashMap<String, Object>();
        Optional.ofNullable(this.methods).ifPresent(children::putAll);
        Optional.ofNullable(this.resources).ifPresent(children::putAll);
        return children;
    }

    public RamlMethod method(String method) {
        String methodlower;
        RamlMethod value;
        if (this.methods == null) {
            this.methods = new LinkedHashMap<String, RamlMethod>();
        }
        if ((value = this.methods.get(methodlower = method.toLowerCase())) == null) {
            value = new RamlMethod(methodlower);
            this.methods.put(methodlower, value);
        }
        return value;
    }

    public void setMethods(Map<String, RamlMethod> methods) {
        this.methods = methods;
    }

    public void setResources(Map<String, RamlPath> resources) {
        this.resources = resources;
    }

    public Map<String, RamlParameter> getUriParameters() {
        return this.uriParameters;
    }

    public void setUriParameters(Map<String, RamlParameter> uriParameters) {
        this.uriParameters = uriParameters;
    }

    public RamlParameter uriParameter(String name) {
        RamlParameter param;
        if (this.uriParameters == null) {
            this.uriParameters = new LinkedHashMap<String, RamlParameter>();
        }
        if ((param = this.uriParameters.get(name)) == null) {
            param = new RamlParameter(name);
            this.uriParameters.put(name, param);
        }
        return param;
    }

    public RamlPath path(String pattern) {
        RamlPath path;
        if (this.resources == null) {
            this.resources = new LinkedHashMap<String, RamlPath>();
        }
        if ((path = this.resources.get(pattern)) == null) {
            path = new RamlPath();
            this.resources.put(pattern, path);
        }
        return path;
    }
}

