/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.apitool;

import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jooby.Route;
import org.jooby.Status;
import org.jooby.internal.apitool.DocItem;
import org.jooby.internal.apitool.antlr.ANTLRErrorListener;
import org.jooby.internal.apitool.antlr.BaseErrorListener;
import org.jooby.internal.apitool.antlr.CharStream;
import org.jooby.internal.apitool.antlr.CharStreams;
import org.jooby.internal.apitool.antlr.CodePointCharStream;
import org.jooby.internal.apitool.antlr.CommonTokenStream;
import org.jooby.internal.apitool.antlr.RecognitionException;
import org.jooby.internal.apitool.antlr.Recognizer;
import org.jooby.internal.apitool.antlr.tree.ParseTree;
import org.jooby.internal.apitool.antlr.tree.ParseTreeWalker;
import org.jooby.internal.apitool.antlr.tree.TerminalNode;
import org.jooby.internal.apitool.javadoc.FuzzyDocBaseListener;
import org.jooby.internal.apitool.javadoc.FuzzyDocLexer;
import org.jooby.internal.apitool.javadoc.FuzzyDocParser;
import org.jooby.internal.apitool.javadoc.JavadocLexer;
import org.jooby.internal.apitool.javadoc.JavadocParser;
import org.jooby.internal.apitool.javadoc.JavadocParserBaseListener;
import org.jooby.internal.apitool.javadoc.StatusCodeBaseListener;
import org.jooby.internal.apitool.javadoc.StatusCodeLexer;
import org.jooby.internal.apitool.javadoc.StatusCodeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocParser {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Path basedir;
    private final Map<String, List<DocItem>> javadocCache = new HashMap<String, List<DocItem>>();

    public DocParser(Path basedir) {
        this.basedir = basedir;
    }

    private List<DocItem> javadoc(Path file) throws IOException {
        return new DocCollector().collect(file);
    }

    public Optional<DocItem> pop(String classname, String method, String pattern) {
        try {
            List<DocItem> javadoc = this.javadoc(classname);
            int pos = IntStream.range(0, javadoc.size()).filter(i -> ((DocItem)javadoc.get(i)).matches(method, pattern)).findFirst().orElse(-1);
            if (pos >= 0) {
                return Optional.ofNullable(javadoc.remove(pos));
            }
        }
        catch (Exception x) {
            this.log.debug("Parsing of javadoc resulted in exception: {}", (Object)classname, (Object)x);
        }
        return Optional.empty();
    }

    private List<DocItem> javadoc(String classname) throws IOException {
        List<DocItem> doc;
        int i = classname.indexOf("$");
        String toplevelClass = classname;
        if (i > 0) {
            toplevelClass = classname.substring(0, i);
        }
        if ((doc = this.javadocCache.get(toplevelClass)) != null) {
            return doc;
        }
        Function<String, Path> path = name -> Arrays.asList(name.split("\\.")).stream().reduce(this.basedir, (base, segment) -> this.basedir.equals(base) ? Paths.get(segment, new String[0]) : base.resolve((String)segment), Path::resolve);
        Path filename = path.apply(toplevelClass);
        Path location = Files.walk(this.basedir, new FileVisitOption[0]).filter(it -> {
            if (Files.isRegularFile(it, new LinkOption[0])) {
                String java = filename.toString() + ".java";
                String kt = filename.toString() + ".kt";
                return it.toString().endsWith(java) || it.toString().endsWith(kt);
            }
            return false;
        }).findFirst().orElse(null);
        if (location == null) {
            throw new FileNotFoundException(filename.toString());
        }
        doc = this.javadoc(location);
        this.javadocCache.put(toplevelClass, doc);
        return doc;
    }

    private static class DocCollector
    extends FuzzyDocBaseListener {
        LinkedList<String> prefix = new LinkedList();
        LinkedList<Boolean> insideRoute = new LinkedList();
        List<DocItem> doc;
        LinkedList<String> summary = new LinkedList();
        Path file;

        private DocCollector() {
        }

        public List<DocItem> collect(Path file) throws IOException {
            this.file = file;
            this.doc = new ArrayList<DocItem>();
            CharStream input = CharStreams.fromPath(file, StandardCharsets.UTF_8);
            FuzzyDocLexer lexer = new FuzzyDocLexer(input);
            ANTLRErrorListener error = DocCollector.errorListener(LoggerFactory.getLogger(DocCollector.class), file);
            lexer.removeErrorListeners();
            lexer.addErrorListener(error);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            FuzzyDocParser parser = new FuzzyDocParser(tokens);
            parser.removeErrorListeners();
            parser.addErrorListener(error);
            ParseTreeWalker.DEFAULT.walk(this, parser.source());
            return this.doc;
        }

        private static ANTLRErrorListener errorListener(final Logger log, final Path file) {
            return new BaseErrorListener(){

                @Override
                public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                    log.debug("{}:{}:{} {}", new Object[]{file, line, charPositionInLine, msg});
                }
            };
        }

        @Override
        public void enterUse(FuzzyDocParser.UseContext ctx) {
            if (ctx.comma.size() > 0) {
                String comment = ctx.doc.getText();
                String method = Optional.ofNullable(ctx.method).map(it -> this.str(it.getText())).orElse("*");
                String pattern = Optional.ofNullable(ctx.pattern).map(it -> this.str(it.getText())).orElse("*");
                this.doc.add(DocCollector.doc(method, Route.normalize((String)pattern), this.file, this.summary(), comment));
            } else {
                this.prefix.addLast(Route.normalize((String)this.str(ctx.pattern.getText())));
                this.popInsideRoute();
                this.summary.addLast(DocCollector.cleanJavadoc(this.file, ctx.doc.getText()));
            }
        }

        @Override
        public void enterPath(FuzzyDocParser.PathContext ctx) {
            this.prefix.addLast(Route.normalize((String)this.str(ctx.pattern.getText())));
            this.insideRoute.addLast(true);
            if (ctx.doc != null) {
                this.summary.addLast(DocCollector.cleanJavadoc(this.file, ctx.doc.getText()));
            }
        }

        @Override
        public void exitPath(FuzzyDocParser.PathContext ctx) {
            this.popPrefix();
            this.popSummary();
            this.popInsideRoute();
        }

        @Override
        public void enterRoute(FuzzyDocParser.RouteContext ctx) {
            this.prefix.addLast(Route.normalize((String)this.str(ctx.pattern.getText())));
            this.insideRoute.addLast(true);
            this.summary.addLast(DocCollector.cleanJavadoc(this.file, ctx.doc.getText()));
        }

        @Override
        public void exitRoute(FuzzyDocParser.RouteContext ctx) {
            this.popPrefix();
            this.popSummary();
            this.popInsideRoute();
        }

        @Override
        public void enterScript(FuzzyDocParser.ScriptContext ctx) {
            if (ctx.dot == null && !this.insideRoute()) {
                this.popPrefix();
                this.popSummary();
            }
            String comment = Optional.ofNullable(ctx.doc).map(it -> it.getText()).orElse("");
            if (ctx.method != null) {
                String method = ctx.method.getText();
                String pattern = this.prefix.stream().collect(Collectors.joining("")) + "/" + Optional.ofNullable(ctx.pattern).map(it -> this.str(it.getText())).orElse("/");
                this.doc.add(DocCollector.doc(method, Route.normalize((String)pattern), this.file, this.summary(), comment));
            }
        }

        private void popSummary() {
            if (this.summary.size() > 0) {
                this.summary.removeLast();
            }
        }

        private boolean insideRoute() {
            return this.insideRoute.isEmpty() ? false : this.insideRoute.getLast();
        }

        private void popInsideRoute() {
            if (this.insideRoute.size() > 0) {
                this.insideRoute.removeLast();
            }
        }

        private String summary() {
            return this.summary.stream().collect(Collectors.joining());
        }

        @Override
        public void enterClazz(FuzzyDocParser.ClazzContext ctx) {
            String pattern = this.pattern(ctx.annotations);
            if (pattern != null) {
                boolean isClass;
                boolean bl = isClass = ctx.isClass != null;
                if (isClass) {
                    this.prefix.addLast(Route.normalize((String)pattern));
                    if (ctx.doc != null) {
                        this.summary.addLast(DocCollector.cleanJavadoc(this.file, ctx.doc.getText()));
                    }
                } else {
                    this.popPrefix();
                    this.popSummary();
                    List<String> methods = this.methods(ctx.annotations);
                    if (ctx.doc != null) {
                        String comment = ctx.doc.getText();
                        if (methods.size() == 0) {
                            this.doc.add(DocCollector.doc("get", Route.normalize((String)pattern), this.file, this.summary(), comment));
                        } else {
                            methods.stream().forEach(it -> this.doc.add(DocCollector.doc(it, Route.normalize((String)pattern), this.file, this.summary(), comment)));
                        }
                    }
                }
            } else {
                this.popPrefix();
            }
        }

        @Override
        public void exitClazz(FuzzyDocParser.ClazzContext ctx) {
            this.popPrefix();
        }

        private void popPrefix() {
            if (this.prefix.size() > 0) {
                this.prefix.removeLast();
            }
        }

        private String pattern(List<FuzzyDocParser.AnnotationContext> annotations) {
            return annotations.stream().filter(it -> it.name.getText().equals("@Path")).findFirst().map(it -> Optional.ofNullable(it.value).map(e -> this.str(e.getText())).orElse("/")).orElse(null);
        }

        private List<String> methods(List<FuzzyDocParser.AnnotationContext> annotations) {
            return annotations.stream().filter(it -> Route.METHODS.contains(it.name.getText().substring(1))).map(it -> it.name.getText().substring(1)).collect(Collectors.toList());
        }

        @Override
        public void enterMvcRoute(FuzzyDocParser.MvcRouteContext ctx) {
            String path = this.pattern(ctx.annotations);
            List<String> methods = this.methods(ctx.annotations);
            if (methods.isEmpty() && path == null) {
                return;
            }
            String comment = ctx.doc.getText();
            String pattern = this.prefix.stream().collect(Collectors.joining()) + "/" + Optional.ofNullable(path).orElse("/");
            if (methods.size() == 0) {
                this.doc.add(DocCollector.doc("get", Route.normalize((String)pattern), this.file, this.summary(), comment));
            } else {
                methods.stream().forEach(method -> this.doc.add(DocCollector.doc(method, Route.normalize((String)pattern), this.file, this.summary(), comment)));
            }
        }

        private static JavadocParser.DocumentationContext parseJavadoc(Path file, String doc) {
            ANTLRErrorListener error = DocCollector.errorListener(LoggerFactory.getLogger(DocCollector.class), file);
            CodePointCharStream stream = CharStreams.fromString(doc == null ? "" : doc);
            JavadocLexer lexer = new JavadocLexer(stream);
            lexer.removeErrorListeners();
            lexer.addErrorListener(error);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            JavadocParser parser = new JavadocParser(tokens);
            parser.removeErrorListeners();
            parser.addErrorListener(error);
            return parser.documentation();
        }

        private static String cleanJavadoc(Path file, String doc) {
            return DocCollector.cleanJavadoc(DocCollector.parseJavadoc(file, doc));
        }

        private static String cleanJavadoc(JavadocParser.DocumentationContext ctx) {
            final StringBuilder buff = new StringBuilder();
            JavadocParserBaseListener listener = new JavadocParserBaseListener(){

                @Override
                public void enterDescriptionLine(JavadocParser.DescriptionLineContext ctx) {
                    buff.append(ctx.getText()).append("\n");
                }
            };
            ParseTreeWalker.DEFAULT.walk(listener, ctx);
            return buff.toString();
        }

        private static DocItem doc(String method, String pattern, Path file, String summary, String doc) {
            final LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            final StringBuilder returns = new StringBuilder();
            final StringBuilder text = new StringBuilder();
            JavadocParserBaseListener listener = new JavadocParserBaseListener(){

                @Override
                public void enterDescriptionLine(JavadocParser.DescriptionLineContext ctx) {
                    text.append(ctx.getText()).append("\n");
                }

                @Override
                public void enterBlockTag(JavadocParser.BlockTagContext ctx) {
                    String tag = ctx.blockTagName().NAME().getText();
                    List terminals = ctx.blockTagContent().stream().flatMap(it -> DocCollector.terminals(it).stream()).collect(Collectors.toList());
                    boolean param = false;
                    if (tag.equals("param") && terminals.size() > 0) {
                        tag = ((TerminalNode)terminals.get(0)).getText();
                        param = true;
                    }
                    String desc = terminals.stream().skip(param ? 1L : 0L).map(ParseTree::getText).filter(it -> !it.trim().equals("*")).collect(Collectors.joining()).trim();
                    if (param) {
                        params.put(tag, Strings.emptyToNull((String)desc));
                    } else if (tag.equals("return")) {
                        returns.append(desc);
                    }
                }
            };
            ParseTreeWalker.DEFAULT.walk(listener, DocCollector.parseJavadoc(file, doc));
            return new DocItem(method, pattern, summary, text.toString(), params, returns.toString(), DocCollector.statusCodes(returns.toString()));
        }

        static Map<Integer, String> statusCodes(String text) {
            if (text.length() == 0) {
                return new LinkedHashMap<Integer, String>();
            }
            CodePointCharStream input = CharStreams.fromString(text);
            StatusCodeLexer lexer = new StatusCodeLexer(input);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            StatusCodeParser parser = new StatusCodeParser(tokens);
            final LinkedHashMap<Integer, String> statusCodes = new LinkedHashMap<Integer, String>();
            StatusCodeBaseListener listener = new StatusCodeBaseListener(){

                @Override
                public void enterHtmlCode(StatusCodeParser.HtmlCodeContext ctx) {
                    this.parse(ctx.statusCode.getText().replace("<code>", "").replace("</code>", ""));
                }

                @Override
                public void enterJsonCode(StatusCodeParser.JsonCodeContext ctx) {
                    String json = ctx.statusCode.getText();
                    this.parse(json.substring(1, json.length() - 1));
                }

                @Override
                public void enterMarkdownCode(StatusCodeParser.MarkdownCodeContext ctx) {
                    String md = ctx.statusCode.getText();
                    this.parse(md.substring(1, md.length() - 1));
                }

                private void parse(String text) {
                    Pattern pattern = Pattern.compile("(\\d+)\\s*([:=]\\s*((.*)))?");
                    Matcher matcher = pattern.matcher(text);
                    if (matcher.find()) {
                        try {
                            int statusCode = Integer.parseInt(matcher.group(1).trim());
                            String desc = Optional.ofNullable(matcher.group(3)).orElse(Status.valueOf((int)statusCode).reason());
                            statusCodes.put(statusCode, desc);
                        }
                        catch (IllegalArgumentException x) {
                            LoggerFactory.getLogger(DocParser.class).debug("Ignoring status code", (Throwable)x);
                        }
                    }
                }
            };
            ParseTreeWalker.DEFAULT.walk(listener, parser.text());
            return statusCodes;
        }

        static List<TerminalNode> terminals(ParseTree context) {
            ArrayList<TerminalNode> terminals = new ArrayList<TerminalNode>();
            for (int i = 0; i < context.getChildCount(); ++i) {
                if (context.getChild(i) instanceof TerminalNode) {
                    terminals.add((TerminalNode)context.getChild(i));
                    continue;
                }
                terminals.addAll(DocCollector.terminals(context.getChild(i)));
            }
            return terminals;
        }

        private String str(String text) {
            return text.substring(1, text.length() - 1);
        }
    }
}

