/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.apitool;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jooby.Jooby;
import org.jooby.Mutant;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Router;
import org.jooby.internal.apitool.Signature;
import org.jooby.internal.apitool.asm.Type;
import org.jooby.internal.apitool.asm.tree.AbstractInsnNode;
import org.jooby.internal.apitool.asm.tree.MethodInsnNode;
import org.jooby.internal.apitool.asm.tree.MethodNode;

class Filters {
    private static List<Signature> PARAMS = Filters.params();

    Filters() {
    }

    public static Predicate<MethodInsnNode> joobyRun(ClassLoader loader) {
        return Filters.call(loader, "org.jooby.JoobyKt", "run", "kotlin.jvm.functions.Function0", String.class.getName() + "[]").or(Filters.call(loader, "org.jooby.Jooby", "run", Supplier.class, String.class.getName() + "[]"));
    }

    public static <T> Predicate<T> is(Class<? extends T> type) {
        return type::isInstance;
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... predicates) {
        return n -> Arrays.asList(predicates).stream().reduce(true, (value, predicate) -> value != false && predicate.test(n), (l, r) -> l != false && r != false);
    }

    public static <T extends AbstractInsnNode> Predicate<T> opcode(int opcode) {
        return it -> it.getOpcode() == opcode;
    }

    public static Predicate<MethodInsnNode> call(Class owner, String name, Object ... args) {
        return Filters.call(owner.getClassLoader(), Type.getInternalName(owner), name, args);
    }

    public static Predicate<MethodInsnNode> call(ClassLoader loader, String owner, String name, Object ... args) {
        return Filters.is(MethodInsnNode.class).and(m -> new Signature(loader, owner, name, args).matches((MethodInsnNode)m));
    }

    public static Predicate<MethodNode> access(int access) {
        return Filters.is(MethodNode.class).and(m -> (m.access & access) != 0);
    }

    public static Predicate<MethodNode> kotlinRouteHandler() {
        return Filters.is(MethodNode.class).and(m -> (m.name.equals("invoke") || m.name.equals("handle")) && (m.access & 0x1000) == 0);
    }

    public static Predicate<MethodInsnNode> mount(ClassLoader loader, String owner) {
        Signature use1 = new Signature(loader, owner, "use", Jooby.class);
        Signature use2 = new Signature(loader, owner, "use", String.class, Jooby.class);
        return Filters.is(MethodInsnNode.class).and(m -> use1.matches((MethodInsnNode)m) || use2.matches((MethodInsnNode)m));
    }

    public static Predicate<MethodInsnNode> use(ClassLoader loader, String owner) {
        Signature use = new Signature(loader, owner, "use", Class.class);
        Signature usepath = new Signature(loader, owner, "use", String.class, Class.class);
        Signature kuse = new Signature(loader, owner, "use", "kotlin.reflect.KClass");
        Signature kusepath = new Signature(loader, owner, "use", String.class, "kotlin.reflect.KClass");
        return Filters.is(MethodInsnNode.class).and(m -> use.matches((MethodInsnNode)m) || usepath.matches((MethodInsnNode)m) || kuse.matches((MethodInsnNode)m) || kusepath.matches((MethodInsnNode)m));
    }

    public static Predicate<MethodInsnNode> path(ClassLoader loader, String owner) {
        Signature path = new Signature(loader, owner, "path", String.class, Runnable.class);
        return Filters.is(MethodInsnNode.class).and(m -> path.matches((MethodInsnNode)m));
    }

    public static Predicate<MethodNode> methodName(String name) {
        return Filters.is(MethodNode.class).and(m -> m.name.equals(name));
    }

    public static Predicate<MethodInsnNode> sendObject() {
        return Filters.call(Response.class, "send", Object.class.getName());
    }

    public static Predicate<MethodNode> method(String name, Object ... args) {
        return Filters.is(MethodNode.class).and(m -> {
            Type[] params;
            if (name.equals(m.name) && (params = Type.getArgumentTypes(m.desc)).length == args.length) {
                for (int i = 0; i < args.length; ++i) {
                    String param = params[i].getClassName();
                    Object arg = args[i];
                    if (arg instanceof Class) {
                        arg = ((Class)arg).getName();
                    }
                    if (param.equals(arg)) continue;
                    return false;
                }
                return true;
            }
            return false;
        });
    }

    public static Predicate<MethodInsnNode> scriptRoute(ClassLoader loader) {
        List<Signature> routes = Filters.collectScriptRoutes(loader);
        return Filters.is(MethodInsnNode.class).and(m -> {
            Signature signature = new Signature(loader, (MethodInsnNode)m);
            return routes.stream().filter(signature::matches).findFirst().isPresent();
        });
    }

    public static Predicate<MethodInsnNode> getOrCreateKotlinClass() {
        return m -> m.owner.equals("kotlin/jvm/internal/Reflection") && m.name.equals("getOrCreateKotlinClass");
    }

    public static Predicate<MethodInsnNode> mutantToSomething() {
        return m -> m.owner.equals(Mutant.class.getName().replace('.', '/')) && m.name.startsWith("to");
    }

    public static Predicate<MethodInsnNode> mutantValue() {
        return m -> {
            Type[] args;
            if (m.owner.equals(Mutant.class.getName().replace('.', '/'))) {
                return m.name.equals("value") || m.name.endsWith("Value");
            }
            if (m.owner.equals("org/jooby/JoobyKt") && m.name.startsWith("get") && m.name.endsWith("Value") && (args = Type.getArgumentTypes(m.desc)).length >= 1) {
                return args[0].getClassName().equals(Mutant.class.getName());
            }
            return false;
        };
    }

    public static Predicate<MethodInsnNode> param(ClassLoader loader) {
        return Filters.is(MethodInsnNode.class).and(m -> {
            Signature signature = new Signature(loader, (MethodInsnNode)m);
            return PARAMS.stream().filter(signature::matches).findFirst().isPresent();
        });
    }

    public static Predicate<MethodInsnNode> file() {
        return Filters.is(MethodInsnNode.class).and(m -> (m.name.equals("file") || m.name.equals("files")) && m.owner.equals(Request.class.getName().replace(".", "/")));
    }

    private static List<Signature> params() {
        Predicate<Method> args = Filters.argument(String.class).or(Filters.argument(String.class, String[].class)).or(Filters.argument(Class.class));
        List<Signature> signatures = Filters.signatures(Request.class, m -> {
            String name;
            switch (name = m.getName()) {
                case "param": 
                case "header": 
                case "file": 
                case "files": 
                case "params": 
                case "form": {
                    return args.test((Method)m);
                }
                case "body": {
                    return m.getParameterCount() == 0 || args.test((Method)m);
                }
            }
            return false;
        });
        return signatures;
    }

    private static List<Signature> collectScriptRoutes(ClassLoader loader) {
        Function<String, Optional> loadClass = name -> {
            try {
                return Optional.of(loader.loadClass((String)name));
            }
            catch (ClassNotFoundException e) {
                return Optional.empty();
            }
        };
        Predicate<Method> route = Filters.argument(Route.ZeroArgHandler.class).or(Filters.argument(Route.OneArgHandler.class)).or(Filters.argument(Route.Handler.class)).or(Filters.argument(Route.Filter.class)).or(Filters.argument(String.class, Route.ZeroArgHandler.class)).or(Filters.argument(String.class, Route.OneArgHandler.class)).or(Filters.argument(String.class, Route.Handler.class)).or(Filters.argument(String.class, Route.Filter.class)).or(Filters.argument(String.class, String.class, Route.ZeroArgHandler.class)).or(Filters.argument(String.class, String.class, Route.OneArgHandler.class)).or(Filters.argument(String.class, String.class, Route.Handler.class)).or(Filters.argument(String.class, String.class, Route.Filter.class)).or(Filters.argument(String.class, String.class, String.class, Route.ZeroArgHandler.class)).or(Filters.argument(String.class, String.class, String.class, Route.OneArgHandler.class)).or(Filters.argument(String.class, String.class, String.class, Route.Handler.class)).or(Filters.argument(String.class, String.class, String.class, Route.Filter.class));
        Predicate<Method> krouteArg = Filters.argument("kotlin.jvm.functions.Function1").or(Filters.argument("kotlin.jvm.functions.Function2")).or(Filters.argument("kotlin.jvm.functions.Function3")).or(Filters.argument(String.class, "kotlin.jvm.functions.Function1")).or(Filters.argument(String.class, "kotlin.jvm.functions.Function2")).or(Filters.argument(String.class, "kotlin.jvm.functions.Function3")).or(Filters.argument(String.class, String.class, "kotlin.jvm.functions.Function1")).or(Filters.argument(String.class, String.class, "kotlin.jvm.functions.Function2")).or(Filters.argument(String.class, String.class, "kotlin.jvm.functions.Function3")).or(Filters.argument("org.jooby.Kooby", String.class, "kotlin.jvm.functions.Function1", Integer.TYPE, Object.class)).or(Filters.argument("org.jooby.Kooby", String.class, "kotlin.jvm.functions.Function2", Integer.TYPE, Object.class)).or(Filters.argument("org.jooby.Kooby", String.class, "kotlin.jvm.functions.Function3", Integer.TYPE, Object.class));
        Predicate<Method> kotlinScriptRoute = m -> {
            String name = m.getName().replace("$default", "").toUpperCase();
            if (Route.METHODS.contains(name) || name.equals("ALL")) {
                return krouteArg.test((Method)m);
            }
            return false;
        };
        List<Signature> signatures = Filters.signatures(Router.class, route);
        loadClass.apply("org.jooby.Kooby").ifPresent(c -> signatures.addAll(Filters.signatures(c, kotlinScriptRoute)));
        loadClass.apply("org.jooby.KRouteGroup").ifPresent(c -> signatures.addAll(Filters.signatures(c, kotlinScriptRoute)));
        return signatures;
    }

    private static Predicate<Method> argument(Object ... types) {
        return m -> {
            Class<?>[] params = m.getParameterTypes();
            if (params.length == types.length) {
                for (int i = 0; i < types.length; ++i) {
                    Object type = types[i];
                    Object it = type instanceof String ? params[i].getName() : params[i];
                    if (it.equals(type)) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    private static List<Signature> signatures(Class owner, Predicate<Method> filter) {
        Method[] methods = owner.getDeclaredMethods();
        ArrayList<Signature> result = new ArrayList<Signature>();
        for (Method method : methods) {
            String name = method.getName();
            if (name.contains("deferred") || !filter.test(method)) continue;
            result.add(new Signature(method));
        }
        return result;
    }
}

