/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.apitool;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.SimpleType;
import io.swagger.util.Json;
import java.lang.reflect.Type;

public class FriendlyTypeName {
    public static String name(Type type) {
        return FriendlyTypeName.name(Json.mapper().constructType(type));
    }

    public static String name(JavaType type) {
        if (type instanceof ArrayType) {
            return "Array[" + FriendlyTypeName.name(type.getContentType()) + "]";
        }
        if (type instanceof CollectionLikeType) {
            return type.getRawClass().getSimpleName() + "[" + FriendlyTypeName.name(type.getContentType()) + "]";
        }
        if (type instanceof MapLikeType) {
            return "Map[" + FriendlyTypeName.name(type.getKeyType()) + ":" + FriendlyTypeName.name(type.getContentType()) + "]";
        }
        if (type instanceof SimpleType) {
            String name = type.getRawClass().getSimpleName();
            StringBuilder args = new StringBuilder();
            for (int i = 0; i < type.containedTypeCount(); ++i) {
                args.append(FriendlyTypeName.name(type.containedType(i))).append(",");
            }
            if (args.length() > 0) {
                args.insert(0, '[');
                args.setCharAt(args.length() - 1, ']');
            }
            return name + args;
        }
        return type.getRawClass().getSimpleName();
    }
}

