/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.apitool;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.converter.ModelConverters;
import io.swagger.jackson.AbstractModelConverter;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooby.MediaType;
import org.jooby.Upload;
import org.jooby.apitool.RouteMethod;
import org.jooby.apitool.RouteParameter;
import org.jooby.apitool.RouteResponse;
import org.jooby.internal.apitool.FriendlyTypeName;

public class SwaggerBuilder {
    private Function<RouteMethod, String> tagger;

    public SwaggerBuilder(Function<RouteMethod, String> tagger) {
        this.tagger = tagger;
    }

    public Swagger build(Swagger base, List<RouteMethod> routes) throws Exception {
        Swagger swagger = Optional.ofNullable(base).orElseGet(Swagger::new);
        Function<String, Tag> tagFactory = value -> Optional.ofNullable(swagger.getTag(value)).orElseGet(() -> {
            Tag tag = new Tag().name(value);
            swagger.addTag(tag);
            return tag;
        });
        Function<String, Path> pathFactory = pattern -> Optional.ofNullable(swagger.getPath(pattern)).orElseGet(() -> {
            Path path = new Path();
            swagger.path(pattern, path);
            return path;
        });
        ModelConverters converter = ModelConverters.getInstance();
        final Function<Type, Model> modelFactory = type -> {
            for (Map.Entry entry : converter.readAll(type).entrySet()) {
                swagger.addDefinition((String)entry.getKey(), this.doModel((Type)type, (Model)entry.getValue()));
            }
            Property property = converter.readAsProperty(type);
            EnumMap args = new EnumMap(PropertyBuilder.PropertyId.class);
            return PropertyBuilder.toModel((Property)PropertyBuilder.merge((Property)property, args));
        };
        HashMap<String, Integer> opIds = new HashMap<String, Integer>();
        for (RouteMethod route : routes) {
            List<Tag> tags = this.tags(route, tagFactory);
            Path path = pathFactory.apply(route.pattern());
            Operation op = new Operation();
            tags.forEach(it -> op.addTag(it.getName()));
            op.operationId(this.operationId(route, tags.get(0), opIds));
            op.summary(this.summary(route));
            op.description(this.description(route, op.getSummary()));
            this.consumes(route, arg_0 -> ((Operation)op).addConsumes(arg_0));
            this.produces(route, arg_0 -> ((Operation)op).addProduces(arg_0));
            route.parameters().stream().flatMap(it -> {
                Type type = it.type();
                final Property property = converter.readAsProperty(type);
                Parameter parameter = it.accept(new RouteParameter.Visitor<Parameter>(){

                    @Override
                    public Parameter visitBody(RouteParameter parameter) {
                        return new BodyParameter().schema((Model)modelFactory.apply(parameter.type()));
                    }

                    @Override
                    public Parameter visitFile(RouteParameter parameter) {
                        return SwaggerBuilder.this.complement(property, parameter, (SerializableParameter)new FormParameter());
                    }

                    @Override
                    public Parameter visitForm(RouteParameter parameter) {
                        return SwaggerBuilder.this.complement(property, parameter, (SerializableParameter)new FormParameter());
                    }

                    @Override
                    public Parameter visitHeader(RouteParameter parameter) {
                        return SwaggerBuilder.this.complement(property, parameter, (SerializableParameter)new HeaderParameter());
                    }

                    @Override
                    public Parameter visitPath(RouteParameter parameter) {
                        return SwaggerBuilder.this.complement(property, parameter, (SerializableParameter)new PathParameter());
                    }

                    @Override
                    public Parameter visitQuery(RouteParameter parameter) {
                        return SwaggerBuilder.this.complement(property, parameter, (SerializableParameter)new QueryParameter());
                    }
                });
                if (it.kind() == RouteParameter.Kind.FILE) {
                    op.setConsumes((List)ImmutableList.of((Object)MediaType.multipart.name()));
                } else if (it.kind() == RouteParameter.Kind.FORM) {
                    op.setConsumes((List)ImmutableList.of((Object)MediaType.form.name(), (Object)MediaType.multipart.name()));
                }
                if (property instanceof RefProperty && (it.kind() == RouteParameter.Kind.QUERY || it.kind() == RouteParameter.Kind.FORM)) {
                    return this.expandParameter(converter, (RouteParameter)it, it.type(), it.optional()).stream();
                }
                parameter.setName(it.name());
                parameter.setRequired(!it.optional());
                parameter.setDescription(property.getDescription());
                it.description().ifPresent(arg_0 -> ((Parameter)parameter).setDescription(arg_0));
                return Stream.of(parameter);
            }).forEach(arg_0 -> ((Operation)op).addParameter(arg_0));
            this.buildResponse(route, modelFactory, (ResponseWithStatusCode rsp) -> op.addResponse(rsp.statusCode, rsp.response));
            path.set(this.method(route), op);
        }
        Function<Function, List> mediaTypes = types -> routes.stream().flatMap(it -> ((List)types.apply(it)).stream()).collect(Collectors.toList());
        List consumes = mediaTypes.apply(RouteMethod::consumes);
        if (consumes.size() == 0) {
            swagger.consumes(MediaType.json.name());
        } else if (consumes.size() == 1) {
            swagger.consumes(consumes);
        }
        List produces = mediaTypes.apply(RouteMethod::produces);
        if (produces.size() == 0) {
            swagger.produces(MediaType.json.name());
        } else if (produces.size() == 1) {
            swagger.produces(produces);
        }
        return swagger;
    }

    private void buildResponse(RouteMethod route, Function<Type, Model> modelFactory, Consumer<ResponseWithStatusCode> consumer) {
        Object[] apiResponses = (Object[])route.attributes().get("apiResponses");
        if (apiResponses != null) {
            HashSet codes = new HashSet();
            Stream.of(apiResponses).map(it -> this.buildResponse(modelFactory, (Map)it, (Integer c) -> !codes.add(c))).forEach(consumer);
        } else {
            Integer code = (Integer)route.attributes().get("apiResponse.code");
            if (code != null) {
                consumer.accept(this.buildResponse(modelFactory, route.attributes(), (Integer c) -> false));
            } else {
                RouteResponse returns = route.response();
                Map<Integer, String> status = returns.status();
                Integer statusCode = (Integer)route.attributes().getOrDefault("apiOperation.code", returns.statusCode());
                Response response = new Response();
                String doc = returns.description().orElseGet(() -> FriendlyTypeName.name(returns.type()));
                response.description(doc);
                Type responseType = (Type)route.attributes().getOrDefault("apiOperation.response", returns.type());
                if (!this.isVoid(responseType)) {
                    response.responseSchema(modelFactory.apply(responseType));
                }
                this.buildResponseHeader(route.attributes(), "apiOperation.responseHeaders", (arg_0, arg_1) -> ((Response)response).addHeader(arg_0, arg_1));
                consumer.accept(new ResponseWithStatusCode(statusCode.toString(), response));
                status.entrySet().stream().filter(it -> !statusCode.equals(it.getKey())).forEach(it -> consumer.accept(new ResponseWithStatusCode(((Integer)it.getKey()).toString(), new Response().description((String)it.getValue()))));
            }
        }
    }

    private boolean isVoid(Type type) {
        return "void".equals(type.getTypeName()) || Void.class.getName().equals(type.getTypeName());
    }

    private ResponseWithStatusCode buildResponse(Function<Type, Model> modelFactory, Map<String, Object> attributes, Predicate<Integer> statusCode) {
        Response response = new Response();
        String description = (String)attributes.get("apiResponse.message");
        Class type = (Class)attributes.get("apiResponse.response");
        if (!this.isVoid(type)) {
            response.setResponseSchema(modelFactory.apply(type));
        }
        response.setDescription(description);
        this.buildResponseHeader(attributes, "apiResponse.responseHeaders", (arg_0, arg_1) -> ((Response)response).addHeader(arg_0, arg_1));
        Integer code = (Integer)attributes.get("apiResponse.code");
        String key = code.toString();
        if (statusCode.test(code)) {
            key = key + "(" + type.getSimpleName() + ")";
        }
        return new ResponseWithStatusCode(key, response);
    }

    private void buildResponseHeader(Map<String, Object> attributes, String name, BiConsumer<String, Property> consumer) {
        Object[] headers = (Object[])attributes.get(name);
        if (headers != null) {
            ModelConverters converter = ModelConverters.getInstance();
            Stream.of(headers).map(Map.class::cast).filter(it -> ((String)it.get("responseHeader.name")).length() > 0).forEach(header -> {
                String hname = header.get("responseHeader.name").toString();
                Property htype = converter.readAsProperty((Type)header.get("responseHeader.response"));
                consumer.accept(hname, htype);
            });
        }
    }

    private String method(RouteMethod route) {
        String method = this.stringAttribute(route, "httpMethod");
        if (method == null) {
            method = route.method();
        }
        return method.toLowerCase();
    }

    private void consumes(RouteMethod route, Consumer<String> consumer) {
        String consumes = this.stringAttribute(route, "consumes");
        if (consumes == null) {
            route.consumes().forEach(consumer::accept);
        } else {
            Stream.of(consumes.split(",")).forEach(consumer);
        }
    }

    private void produces(RouteMethod route, Consumer<String> consumer) {
        String produces = this.stringAttribute(route, "produces");
        if (produces == null) {
            route.produces().forEach(consumer::accept);
        } else {
            Stream.of(produces.split(",")).forEach(consumer);
        }
    }

    private String description(RouteMethod route, String summary) {
        String notes = this.stringAttribute(route, "notes");
        if (notes == null) {
            return route.description().map(description -> {
                String prefix = Optional.ofNullable(summary).orElse("");
                return description.replace(prefix + ".", "");
            }).orElse(null);
        }
        return notes;
    }

    private String summary(RouteMethod route) {
        String summary = this.stringAttribute(route, "apiOperation");
        if (summary == null) {
            return route.description().map(description -> {
                int dot = description.indexOf(46);
                if (dot > 0) {
                    return description.substring(0, dot);
                }
                return null;
            }).orElse(null);
        }
        return summary;
    }

    private String operationId(RouteMethod route, Tag tag, Map<String, Integer> opIds) {
        String operationId = this.stringAttribute(route, "nickname");
        if (operationId == null) {
            operationId = route.name().orElseGet(() -> {
                String args = "";
                if (route.method().equals("GET") && route.parameters().size() > 0) {
                    args = route.parameters().stream().filter(p -> p.kind() == RouteParameter.Kind.QUERY || p.kind() == RouteParameter.Kind.PATH).map(p -> p.name()).map(this::ucase).reduce(new StringBuilder("By"), StringBuilder::append, StringBuilder::append).toString();
                }
                return route.method().toLowerCase() + this.ucase(tag.getName().replace("/", "")) + args;
            });
        }
        int c = opIds.getOrDefault(operationId, 0);
        opIds.put(operationId, c + 1);
        if (c == 0) {
            return operationId;
        }
        return operationId + c;
    }

    private List<Tag> tags(RouteMethod route, Function<String, Tag> tagFactory) {
        List<Tag> result;
        String[] tags = (String[])this.arrayAttribute(route, "tags");
        if (tags != null && (result = Stream.of(tags).filter(it -> it.length() > 0).map(tagFactory).collect(Collectors.toList())).size() > 0) {
            return result;
        }
        Tag tag = tagFactory.apply(this.tagger.apply(route));
        route.summary().ifPresent(arg_0 -> ((Tag)tag).description(arg_0));
        return ImmutableList.of((Object)tag);
    }

    private String stringAttribute(RouteMethod route, String name) {
        return (String)this.swaggerAttribute(route, name, it -> it.toString().length() > 0);
    }

    private <T> T[] arrayAttribute(RouteMethod routeMethod, String name) {
        return (Object[])this.swaggerAttribute(routeMethod, "tags", v -> Array.getLength(v) > 0);
    }

    private Object swaggerAttribute(RouteMethod route, String name, Predicate<Object> filter) {
        String[] prefix;
        for (String p : prefix = new String[]{"apiOperation", "swagger"}) {
            String key = p.equalsIgnoreCase(name) ? name : p + "." + name;
            Object value = route.attributes().get(key);
            if (value == null || !filter.test(value)) continue;
            return value;
        }
        return null;
    }

    private void apiOperation(Map<String, Object> attributes, Operation op, Response response, Function<Type, Model> modelFactory, Function<String, Tag> tagFactory) {
        attributes.forEach((name, value) -> {
            switch (name) {
                case "apiOperation": {
                    String summary = Strings.emptyToNull((String)((String)value));
                    if (summary == null) break;
                    op.summary(summary);
                    break;
                }
                case "tags": {
                    Stream.of((String[])value).filter(it -> it != null && it.trim().length() > 0).map(tagFactory).forEach(tag -> op.addTag(tag.getName()));
                    break;
                }
                case "response": {
                    Class responseType = (Class)value;
                    if (responseType == Void.class) break;
                    response.responseSchema((Model)modelFactory.apply(responseType));
                    break;
                }
                case "nickname": {
                    String operationId = Strings.emptyToNull((String)((String)value));
                    if (operationId == null) break;
                    op.setOperationId(operationId);
                    break;
                }
                case "produces": {
                    String produces = Strings.emptyToNull((String)((String)value));
                    if (produces == null) break;
                    op.produces(Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)produces));
                    break;
                }
                case "consumes": {
                    String consumes = Strings.emptyToNull((String)((String)value));
                    if (consumes == null) break;
                    op.consumes(Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)consumes));
                    break;
                }
                case "code": {
                    int code = (Integer)value;
                    if (code == 200) break;
                    op.addResponse(value.toString(), response);
                    break;
                }
            }
        });
    }

    private Map<String, Object> swaggerAttributes(Class annotation, Map<String, Object> attributes) {
        String name = annotation.getSimpleName();
        return attributes.entrySet().stream().filter(it -> ((String)it.getKey()).equalsIgnoreCase(name) || ((String)it.getKey()).startsWith(name + ".")).filter(it -> {
            Object value = it.getValue();
            if (value instanceof String) {
                return !Strings.isNullOrEmpty((String)((String)value).trim());
            }
            return value != null;
        }).map(e -> {
            String key = (String)e.getKey();
            Object value = attributes.get(key);
            if (key.equalsIgnoreCase(name)) {
                return Maps.immutableEntry((Object)name, value);
            }
            return Maps.immutableEntry((Object)key.replace("apiOperation.", ""), value);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private List<Parameter> expandParameter(ModelConverters converter, RouteParameter it, Type type, boolean optional) {
        Supplier<SerializableParameter> factory = it.kind() == RouteParameter.Kind.FORM ? FormParameter::new : QueryParameter::new;
        return this.expandParameter(converter.readAll(type), it, factory, this.simpleClassName(type), "", optional);
    }

    private List<Parameter> expandParameter(Map<String, Model> models, RouteParameter it, Supplier<SerializableParameter> factory, String typeName, String prefix, boolean optional) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Model model = models.get(typeName);
        Map properties = model.getProperties();
        Optional.ofNullable(properties).ifPresent(props -> props.values().stream().flatMap(arg_0 -> this.lambda$null$32(it, (Supplier)factory, prefix, models, optional, arg_0)).forEach(parameters::add));
        return parameters;
    }

    private String simpleClassName(Type type) {
        return MoreTypes.getRawType((Type)type).getSimpleName();
    }

    private String ucase(String name) {
        if (name.length() > 0) {
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    private Model doModel(Type type, Model model) {
        Map properties = model.getProperties();
        if (properties != null) {
            BeanDescription desc = Json.mapper().getSerializationConfig().introspect(Json.mapper().constructType(type));
            for (BeanPropertyDefinition beanProperty : desc.findProperties()) {
                Property property = (Property)properties.get(beanProperty.getName());
                if (property == null) continue;
                property.setRequired(beanProperty.isRequired());
            }
        }
        return model;
    }

    private SerializableParameter complement(Property property, RouteParameter source, SerializableParameter param) {
        List<String> enums;
        param.setType(property.getType());
        param.setFormat(property.getFormat());
        if (property instanceof ArrayProperty) {
            param.setItems(((ArrayProperty)property).getItems());
        }
        if ((enums = source.enums()).size() > 0) {
            param.setEnum(enums);
        }
        if (param instanceof AbstractSerializableParameter) {
            ((AbstractSerializableParameter)param).setDefault(source.defaultValue());
        }
        return param;
    }

    private /* synthetic */ Stream lambda$null$32(RouteParameter it, Supplier factory, String prefix, Map models, boolean optional, Property p) {
        SerializableParameter result = this.complement(p, it, (SerializableParameter)factory.get());
        String name = prefix + p.getName();
        if (p instanceof RefProperty) {
            return this.expandParameter(models, it, factory, ((RefProperty)p).getSimpleRef(), name + ".", optional).stream();
        }
        result.setName(name);
        boolean required = optional ? false : p.getRequired();
        String desc = Strings.emptyToNull((String)p.getDescription());
        result.setRequired(required);
        result.setDescription(desc);
        return Stream.of(result);
    }

    static {
        ModelConverters.getInstance().addConverter((ModelConverter)new AbstractModelConverter(Json.mapper()){

            public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> chain) {
                if (type == null) {
                    return null;
                }
                try {
                    TypeLiteral typeLiteral = TypeLiteral.get((Type)type);
                    String typeName = typeLiteral.getType().getTypeName();
                    if (typeName.equals("java.util.List<org.jooby.Upload>") || typeName.equals("java.util.Set<org.jooby.Upload>")) {
                        return new ArrayProperty((Property)new FileProperty());
                    }
                    if (typeName.equals(Upload.class.getName())) {
                        return new FileProperty();
                    }
                    return super.resolveProperty(type, context, annotations, chain);
                }
                catch (IllegalArgumentException x) {
                    return super.resolveProperty(type, context, annotations, chain);
                }
            }
        });
        try {
            Module module = (Module)SwaggerBuilder.class.getClassLoader().loadClass("com.fasterxml.jackson.module.kotlin.KotlinModule").newInstance();
            Json.mapper().registerModule(module);
            Yaml.mapper().registerModule(module);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException module) {
            // empty catch block
        }
        Jdk8Module jdk8 = new Jdk8Module();
        Json.mapper().registerModule((Module)jdk8);
        Yaml.mapper().registerModule((Module)jdk8);
    }

    private static class ResponseWithStatusCode {
        String statusCode;
        Response response;

        public ResponseWithStatusCode(String statusCode, Response response) {
            this.statusCode = statusCode;
            this.response = response;
        }
    }
}

