/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.apitool;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.inject.internal.MoreTypes;
import com.google.inject.util.Types;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import org.jooby.internal.apitool.BytecodeRouteParser;

class TypeJsonDeserializer
extends JsonDeserializer<Type> {
    TypeJsonDeserializer() {
    }

    public Type deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String type = p.getValueAsString();
        if (type != null && type.length() > 0) {
            if ("void".equals(type) || Void.class.getName().equals(type)) {
                return Void.TYPE;
            }
            ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
            try {
                return BytecodeRouteParser.loadType(loader, type);
            }
            catch (Exception x) {
                return TypeJsonDeserializer.parse(loader, type, 0).get(0);
            }
        }
        return null;
    }

    private static List<Type> parse(ClassLoader loader, String type, int start) {
        ArrayList<Type> types = new ArrayList<Type>();
        StringBuilder singleType = new StringBuilder();
        for (int i = start; i < type.length(); ++i) {
            Type element;
            char ch = type.charAt(i);
            if (ch == '<') {
                Class owner = BytecodeRouteParser.loadType(loader, singleType.toString());
                List<Type> parameters = TypeJsonDeserializer.parse(loader, type, i + 1);
                types.add(Types.newParameterizedType((Type)owner, (Type[])parameters.toArray(new Type[parameters.size()])));
                return types;
            }
            if (ch == ',') {
                element = BytecodeRouteParser.loadType(loader, singleType.toString());
                types.add(element);
                singleType.setLength(0);
                continue;
            }
            if (ch == '>') {
                if (singleType.length() <= 0) continue;
                element = singleType.charAt(0) == '?' ? TypeJsonDeserializer.parseWildcardType(singleType, loader) : BytecodeRouteParser.loadType(loader, singleType.toString());
                types.add(element);
                singleType.setLength(0);
                continue;
            }
            if (ch == ']') {
                singleType.setLength(singleType.length() - 1);
                element = BytecodeRouteParser.loadType(loader, singleType.toString());
                types.add(Array.newInstance(MoreTypes.getRawType((Type)element), 0).getClass());
                break;
            }
            if (Character.isWhitespace(ch)) continue;
            singleType.append(ch);
        }
        if (types.size() == 0) {
            Class element = BytecodeRouteParser.loadType(loader, singleType.toString());
            types.add(element);
        }
        return types;
    }

    private static Type parseWildcardType(StringBuilder singleType, ClassLoader loader) {
        WildcardType type;
        if (singleType.length() == 1) {
            return new MoreTypes.WildcardTypeImpl(new Type[]{Object.class}, MoreTypes.EMPTY_TYPE_ARRAY);
        }
        switch (singleType.charAt(1)) {
            case 'e': {
                String typeStr = singleType.substring(8);
                type = Types.subtypeOf((Type)BytecodeRouteParser.loadType(loader, typeStr));
                break;
            }
            case 's': {
                String typeStr = singleType.substring(6);
                type = Types.supertypeOf((Type)BytecodeRouteParser.loadType(loader, typeStr));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported wildcard type");
            }
        }
        return type;
    }
}

