/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.frontend;

import com.github.eirslett.maven.plugins.frontend.lib.CacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.NodeInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.google.common.hash.Hashing;
import com.google.inject.Binder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.frontend.MavenCacheResolver;
import org.jooby.frontend.NodeTask;
import org.jooby.funzy.Throwing;
import org.jooby.funzy.Try;

public abstract class Frontend
implements Jooby.Module {
    private Path workDirectory;
    private Path installDirectory;
    private Throwing.Consumer<NodeTask> onStart;
    private Throwing.Consumer<NodeTask> onStarted;
    private final String nodeVersion;

    public Frontend(String nodeVersion) {
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "Node version required.");
    }

    public Frontend workDirectory(Path workDirectory) {
        this.workDirectory = Objects.requireNonNull(workDirectory, "Work directory required.");
        return this;
    }

    public Frontend installDirectory(Path installDirectory) {
        this.installDirectory = Objects.requireNonNull(installDirectory, "Install directory required.");
        return this;
    }

    public Frontend onStart(Throwing.Consumer<NodeTask> callback) {
        this.onStart = callback;
        return this;
    }

    public Frontend onStarted(Throwing.Consumer<NodeTask> callback) {
        this.onStarted = callback;
        return this;
    }

    public void configure(Env env, Config conf, Binder binder) throws Throwable {
        Path userdir = Paths.get(System.getProperty("user.dir"), new String[0]);
        Path workDirectory = Optional.ofNullable(this.workDirectory).orElse(userdir);
        Path installDirectory = Optional.ofNullable(this.installDirectory).orElse(workDirectory);
        ProxyConfig proxy = new ProxyConfig(this.proxies(conf));
        MavenCacheResolver cache = Files.exists(userdir.resolve("pom.xml"), new LinkOption[0]) ? new MavenCacheResolver() : null;
        FrontendPluginFactory factory = new FrontendPluginFactory(workDirectory.toFile(), installDirectory.toFile(), (CacheResolver)cache);
        this.installNode(conf, this.nodeVersion, proxy, factory);
        Map<String, String> environment = this.environment(conf);
        NodeTask task = this.newTask(factory, conf, proxy, environment, this.nodeVersion);
        this.onSyncPackageJson(conf, workDirectory, (Throwing.Consumer<String>)((Throwing.Consumer)x$0 -> task.executeSync((String)x$0, new String[0])));
        if (this.onStart == null && this.onStarted == null) {
            this.onStart = cmd -> cmd.execute("run", "build");
        }
        if (this.onStart != null) {
            env.onStart(() -> this.onStart.accept((Object)task));
        }
        if (this.onStarted != null) {
            env.onStarted(() -> this.onStarted.accept((Object)task));
        }
    }

    private Map<String, String> environment(Config conf) {
        HashMap<String, String> vars = new HashMap<String, String>(System.getenv());
        conf.entrySet().forEach(e -> vars.put((String)e.getKey(), ((ConfigValue)e.getValue()).unwrapped().toString()));
        vars.put("NODE_ENV", conf.getString("application.env").equals("dev") ? "development" : "production");
        return vars;
    }

    private void onSyncPackageJson(Config conf, Path workDirectory, Throwing.Consumer<String> action) throws IOException {
        Path tmp = Paths.get(conf.getString("application.tmpdir"), "package.json");
        Files.createDirectories(tmp, new FileAttribute[0]);
        String sha1 = Hashing.sha256().hashBytes(Files.readAllBytes(workDirectory.resolve("package.json"))).toString();
        Path lastSha1 = tmp.resolve(sha1);
        if (!Files.exists(lastSha1, new LinkOption[0]) || !Files.exists(workDirectory.resolve("node_modules"), new LinkOption[0])) {
            action.accept((Object)"install");
            Try.of(Files.walk(tmp, new FileVisitOption[0])).run(files -> files.filter(f -> !f.equals(tmp)).forEach((Consumer<Path>)Throwing.throwingConsumer(Files::deleteIfExists)));
            Files.write(tmp.resolve(lastSha1), Arrays.asList(""), new OpenOption[0]);
        }
    }

    private void installNode(Config conf, String version, ProxyConfig proxy, FrontendPluginFactory factory) throws InstallationException {
        NodeInstaller installer = factory.getNodeInstaller(proxy).setNodeVersion(version).setNodeDownloadRoot(conf.getString("node.downloadRoot"));
        this.installNpm(installer);
        installer.install();
    }

    protected void installNpm(NodeInstaller node) {
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"frontend.conf");
    }

    private List<ProxyConfig.Proxy> proxies(Config conf) {
        if (conf.hasPath("proxy")) {
            return Arrays.asList(new ProxyConfig.Proxy(conf.getString("proxy.id"), conf.getString("proxy.protocol"), conf.getString("proxy.host"), conf.getInt("proxy.port"), conf.getString("proxy.username"), conf.getString("proxy.password"), conf.getString("proxy.nonProxyHosts")));
        }
        return Collections.emptyList();
    }

    protected abstract NodeTask newTask(FrontendPluginFactory var1, Config var2, ProxyConfig var3, Map<String, String> var4, String var5) throws InstallationException;
}

