/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.frontend;

import com.github.eirslett.maven.plugins.frontend.lib.CacheDescriptor;
import com.github.eirslett.maven.plugins.frontend.lib.CacheResolver;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

class MavenCacheResolver
implements CacheResolver {
    private Path repository = Paths.get(System.getProperty("user.home"), ".m2", "repository");
    private Path groupId = Paths.get("com", "github", "eirslett");

    MavenCacheResolver() {
    }

    public File resolve(CacheDescriptor item) {
        String version = item.getVersion().replace("^", "").replace("v", "");
        String classifier = Optional.ofNullable(item.getClassifier()).map(it -> "-" + it).orElse("");
        Path artifactId = Paths.get(item.getName(), new String[0]).resolve(version).resolve(item.getName() + "-" + version + classifier + "." + item.getExtension());
        return this.repository.resolve(this.groupId).resolve(artifactId).toAbsolutePath().toFile();
    }
}

